#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

struct Purchase {
    long long day;
    long long packages;
};

int main() {
    int N, Q;
    cin >> N >> Q;

    vector<Purchase> purchases(N);
    for (int i = 0; i < N; i++) {
        cin >> purchases[i].day >> purchases[i].packages;
    }

    vector<long long> queries(Q);
    for (int i = 0; i < Q; i++) {
        cin >> queries[i];
    }

    vector<long long> cumulative_sum(N + 1, 0);
    for (int i = 0; i < N; i++) {
        cumulative_sum[i + 1] = cumulative_sum[i] + purchases[i].packages;
    }

    vector<long long> results(Q);
    long long total_eaten = 0;
    long long last_day = 0;
    int current_purchase = 0;

    for (int i = 0; i < Q; i++) {
        long long k = queries[i];

        while (current_purchase < N && purchases[current_purchase].day <= k) {
            long long days = purchases[current_purchase].day - last_day - 1;
            total_eaten += min(days, cumulative_sum[current_purchase] - total_eaten);
            last_day = purchases[current_purchase].day;
            current_purchase++;
        }

        long long remaining_days = k - last_day;
        total_eaten += min(remaining_days, cumulative_sum[current_purchase] - total_eaten);

        results[i] = total_eaten;
        last_day = k;
    }

    for (int i = 0; i < Q; i++) {
        cout << results[i] << endl;
    }

    return 0;
}