#include <iostream>
#include <vector>
using namespace std;

struct Purchase {
    long long day;
    long long packages;
};

int main() {
    int N, Q;
    cin >> N >> Q;

    vector<Purchase> purchases(N);
    for (int i = 0; i < N; i++) {
        cin >> purchases[i].day >> purchases[i].packages;
    }

    vector<long long> queries(Q);
    for (int i = 0; i < Q; i++) {
        cin >> queries[i];
    }

    vector<long long> cumulative_packages(N + 1, 0);
    for (int i = 0; i < N; i++) {
        cumulative_packages[i + 1] = cumulative_packages[i] + purchases[i].packages;
    }

    vector<long long> results(Q);
    for (int i = 0; i < Q; i++) {
        long long k = queries[i];

        long long total_eaten = 0;
        long long last_day = 0;

        for (int j = 0; j < N; j++) {
            if (purchases[j].day > k) break;

            long long days_eaten = min(purchases[j].day - last_day - 1, cumulative_packages[j] - total_eaten);
            total_eaten += days_eaten;
            last_day = purchases[j].day;

            if (purchases[j].day == k) {
                results[i] = total_eaten;
                break;
            }
        }

        if (last_day < k) {
            long long remaining_days = k - last_day;
            total_eaten += min(remaining_days, cumulative_packages[N] - total_eaten);
        }

        results[i] = total_eaten;
    }

    for (const auto& result : results) {
        cout << result << endl;
    }

    return 0;
}