#include <bits/stdc++.h>

using namespace std;

struct polje {
    int x, y;
};

int n, m;

int dx[] = {-1, 1, 0, 0};
int dy[] = {0, 0, -1, 1};

vector<vector<int>> steva(vector<vector<char>>& a, int sx, int sy)
{
    vector<vector<int>> s(n, vector<int>(m, INT_MAX));
    s[sx][sy] = 0;
    queue<polje> q;
    q.push({sx, sy});

    while (!q.empty())
    {
        polje o = q.front();
        q.pop();
        for (int i = 0; i < 4; i++)
        {
            int x2 = o.x + dx[i];
            int y2 = o.y + dy[i];
            if (x2 >= 0 && x2 < n && y2 >= 0 && y2 < m && a[x2][y2] == '.' && s[x2][y2] == INT_MAX)
            {
                s[x2][y2] = s[o.x][o.y] + 1;
                q.push({x2, y2});
            }
        }
    }

    return s;
}


vector<vector<int>> vatra(vector<vector<char>>& a, vector<polje>& sv)
{
    vector<vector<int>> v(n, vector<int>(m, INT_MAX));
    queue<polje> q;
    for (const auto& o : sv)
    {
        v[o.x][o.y] = 0;
        q.push(o);
    }

    while (!q.empty())
    {
        polje o = q.front();
        q.pop();

        for (int i = 0; i < 4; i++)
        {
            int x2 = o.x + dx[i];
            int y2 = o.y + dy[i];
            if (x2 >= 0 && x2 < n && y2 >= 0 && y2 < m && a[x2][y2] == '.' && v[x2][y2] == INT_MAX)
            {
                v[x2][y2] = v[o.x][o.y] + 1;
                q.push({x2, y2});
            }
        }
    }

    return v;
}


int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    cin>>n>>m;

    vector<vector<char>> a(n, vector<char>(m));
    int sx, sy;
    vector<polje> sv;

    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < m; j++)
        {
            cin >> a[i][j];
            if (a[i][j] == 'S')
            {
                sx = i;
                sy = j;
            }
            else if(a[i][j] == 'X')
                sv.push_back({i,j});
        }
    }

    vector<vector<int>> v = vatra(a, sv);
    vector<vector<int>> s = steva(a, sx, sy);

    int z = 0;
    for(int i = 0; i < n; i++)
        for(int j = 0; j < m; j++)
            if(s[i][j] < v[i][j])
                z++;

    cout<<z;

    return 0;
}