#include <iostream>
#include <queue>
#include <vector>
using namespace std;

const int sx[] = {-1, 1, 0, 0};
const int sy[] = {0, 0, -1, 1};
    
void pretraga_u_sirinu(vector<string>& lavirint,int n,int m,vector<vector<int>>& vreme,queue<pair<int, int>>& niz){
    while (!niz.empty()) {
        pair<int, int> current = niz.front();
        niz.pop();
        int x = current.first;
        int y = current.second;
        for (int i = 0; i < 4; i++) {
            int nx = x + sx[i], ny = y + sy[i];
            if (nx >= 0 && nx < n && ny >= 0 && ny < m && lavirint[nx][ny] == '.' && vreme[nx][ny] == 4000000) {
                vreme[nx][ny] = vreme[x][y] + 1;
                niz.push({nx, ny});
            }
        }
    }
}
int main()
{
    
    int n,m;cin>>n>>m;
    vector <string> lavirint(n*m);
    
    pair<int,int> ste_poz;
    vector<vector<int>> vat_vreme(n, vector<int>(m, 4000000)); 
    vector<vector<int>> ste_vreme(n, vector<int>(m, 4000000)); 
    
    queue<pair<int, int>> steva;
    queue<pair<int, int>> vatra;
    
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < m; ++j) {
            cin >> lavirint[i][j];
            if (lavirint[i][j] == 'S') {
                ste_poz = {i, j}; 
                steva.push(ste_poz);
                ste_vreme[ste_poz.first][ste_poz.second] = 0;
            } else if (lavirint[i][j] == 'X') {
                vatra.push({i, j});  
                vat_vreme[i][j] = 0; 
            }
        }
    }
    
    pretraga_u_sirinu(lavirint,n,m,ste_vreme,steva);
    pretraga_u_sirinu(lavirint,n,m,vat_vreme,vatra);
    
    int br = 0;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            if (lavirint[i][j] == '.' && ste_vreme[i][j] < vat_vreme[i][j]) {
                ++br;
            }
        }
    }
        
    cout<<br+1;

    return 0;
}