#include <iostream>
#include <vector>

short N;
short M;
void spread(int** array, int value, short x, short y) {
	if (x == -1 || x == N || y == -1 || y == M) return;
	if (array[x][y] <= value) return;
	array[x][y] = value++;
	spread(array, value, x+1, y);
	spread(array, value, x-1, y);
	spread(array, value, x, y+1);
	spread(array, value, x, y-1);
}

int main() {
	std::ios::sync_with_stdio(false);
	std::cin.tie(NULL);

	std::cin >> N >> M;

	int** s = new int*[N];
	int** v = new int*[N];
	for (int i = 0; i < N; ++i) {
		s[i] = new int[M];
		v[i] = new int[M];
	}

	std::vector<short> queue_s;
	std::vector<short> queue_v;
	char input;
	for (int x = 0; x < N; ++x) {
		for (int y = 0; y < M; ++y) {
			std::cin >> input;
			s[x][y] = -1;
			v[x][y] = -1;
			if (input == '.') {
				s[x][y] = 2147483647;
				v[x][y] = 2147483647;
			} else if (input == 'S') {
				s[x][y] = 0;
				v[x][y] = -2;
				queue_s.push_back(x);
				queue_s.push_back(y);
			} else if (input == 'X') {
				v[x][y] = 0;
				s[x][y] = -2;
				queue_v.push_back(x);
				queue_v.push_back(y);
			}
		}
	}

	int x, y;
	for (int i = 0; i < queue_s.size(); i += 2) {
		x = queue_s[i];
		y = queue_s[i+1];
		spread(s, 1, x+1, y);
		spread(s, 1, x-1, y);
		spread(s, 1, x, y+1);
		spread(s, 1, x, y-1);
	}
	for (int i = 0; i < queue_v.size(); i += 2) {
		x = queue_v[i];
		y = queue_v[i+1];
		spread(v, 1, x+1, y);
		spread(v, 1, x-1, y);
		spread(v, 1, x, y+1);
		spread(v, 1, x, y-1);
	}

	int count = 0;
	for (int x = 0; x < N; ++x) {
		for (int y = 0; y < M; ++y) {
			if (s[x][y] == -2) continue;
			if (s[x][y] < v[x][y] || v[x][y] == -2) ++count;
		}
	}
	std::cout << count;

	/*
	for (int i = 0; i < N; ++i) {
		delete[] s[i];
		delete[] v[i];
	}
	delete[] s;
	delete[] v;
	s = nullptr;
	v = nullptr;*/

	return 0;
}