from collections import deque

def solve_labyrinth(n, m, grid):
    # ?????????
    INF = float('inf')
    
    # ?????? ??????? ???????? ????? ? ?????
    fire_positions = []
    steve_position = None
    for i in range(n):
        for j in range(m):
            if grid[i][j] == 'X':
                fire_positions.append((i, j))
            elif grid[i][j] == 'S':
                steve_position = (i, j)
    
    # ??????? ???????
    fire_time = [[INF] * m for _ in range(n)]
    steve_time = [[INF] * m for _ in range(n)]
    
    # BFS ?? ?????
    fire_queue = deque(fire_positions)
    for i, j in fire_positions:
        fire_time[i][j] = 0
    
    directions = [(-1, 0), (1, 0), (0, -1), (0, 1)]
    
    while fire_queue:
        x, y = fire_queue.popleft()
        for dx, dy in directions:
            nx, ny = x + dx, y + dy
            if 0 <= nx < n and 0 <= ny < m and grid[nx][ny] == '.' and fire_time[nx][ny] == INF:
                fire_time[nx][ny] = fire_time[x][y] + 1
                fire_queue.append((nx, ny))
    
    # BFS ?? ?????
    steve_queue = deque([steve_position])
    steve_time[steve_position[0]][steve_position[1]] = 0
    
    while steve_queue:
        x, y = steve_queue.popleft()
        for dx, dy in directions:
            nx, ny = x + dx, y + dy
            if 0 <= nx < n and 0 <= ny < m and grid[nx][ny] == '.' and steve_time[nx][ny] == INF:
                if steve_time[x][y] + 1 < fire_time[nx][ny]:
                    steve_time[nx][ny] = steve_time[x][y] + 1
                    steve_queue.append((nx, ny))
    
    # ??????? ???????? ????
    result = 0
    for i in range(n):
        for j in range(m):
            if steve_time[i][j] < fire_time[i][j]:
                result += 1
    
    return result

# ????????? ?????
n, m = map(int, input().split())
grid = [input().strip() for _ in range(n)]

# ????? ?????????
print(solve_labyrinth(n, m, grid))