def calculate_plazma_eaten(purchases, stop_day):

    if not purchases or stop_day < purchases[0][0]:
        return 0

    total_eaten = 0
    plazma_available = 0

    for i in range(len(purchases)):
        current_day = purchases[i][0]

        if current_day > stop_day:
            break

        plazma_available += purchases[i][1]

        days_until_next = (
            min(purchases[i + 1][0], stop_day + 1) - current_day if i < len(purchases) - 1
            else stop_day - current_day + 1
        )

        plazma_can_eat = min(days_until_next, plazma_available)
        total_eaten += plazma_can_eat
        plazma_available -= plazma_can_eat

    return total_eaten


def solve_cookie_problem():
    N, Q = map(int, input().split())

    purchases = []
    for _ in range(N):
        day, amount = map(int, input().split())
        purchases.append((day, amount))

    for _ in range(Q):
        stop_day = int(input())
        result = calculate_plazma_eaten(purchases, stop_day)
        print(result)


solve_cookie_problem()