from collections import deque


def solve_maze(n, m, maze):
    steve_pos = None
    fire_positions = []
    for i in range(n):
        for j in range(m):
            if maze[i][j] == 'S':
                steve_pos = (i, j)
            elif maze[i][j] == 'X':
                fire_positions.append((i, j))

    directions = [(-1, 0), (1, 0), (0, -1), (0, 1)]

    fire_time = [[float('inf')] * m for _ in range(n)]
    steve_time = [[float('inf')] * m for _ in range(n)]

    queue = deque()
    for fire_pos in fire_positions:
        queue.append(fire_pos)
        fire_time[fire_pos[0]][fire_pos[1]] = 0

    while queue:
        curr_i, curr_j = queue.popleft()
        curr_time = fire_time[curr_i][curr_j]

        for di, dj in directions:
            new_i, new_j = curr_i + di, curr_j + dj
            if (0 <= new_i < n and 0 <= new_j < m and
                    maze[new_i][new_j] != '*' and
                    fire_time[new_i][new_j] == float('inf')):
                fire_time[new_i][new_j] = curr_time + 1
                queue.append((new_i, new_j))

    queue = deque([(steve_pos[0], steve_pos[1])])
    steve_time[steve_pos[0]][steve_pos[1]] = 0

    while queue:
        curr_i, curr_j = queue.popleft()
        curr_time = steve_time[curr_i][curr_j]

        for di, dj in directions:
            new_i, new_j = curr_i + di, curr_j + dj
            if (0 <= new_i < n and 0 <= new_j < m and
                    maze[new_i][new_j] != '*' and
                    steve_time[new_i][new_j] == float('inf')):
                steve_time[new_i][new_j] = curr_time + 1
                queue.append((new_i, new_j))

    safe_cells = 0
    for i in range(n):
        for j in range(m):
            if (maze[i][j] != '*' and
                    steve_time[i][j] != float('inf') and
                    steve_time[i][j] < fire_time[i][j]):
                safe_cells += 1

    return safe_cells

def read_input():
    n, m = map(int, input().split())
    maze = []
    for _ in range(n):
        row = list(input().strip())
        maze.append(row)
    return n, m, maze


def main():
    n, m, maze = read_input()
    result = solve_maze(n, m, maze)
    print(result)


main()