#include <bits/stdc++.h>

using namespace std;

int inf = INT_MAX;
vector<int> dir = {0, 1, 0, -1, 0};

void BFS_vatra(vector<vector<char>>& mapa, vector<vector<int>>& xmapa, queue<pair<int, int>>& vatra){
    int n = mapa.size();
    int m = mapa[0].size();
    while (!vatra.empty()) {
        int x = vatra.front().first;
        int y = vatra.front().second;
        vatra.pop();
        for (int i = 0; i < 4; i++) {
            int nx = x + dir[i];
            int ny = y + dir[i + 1];
            if (nx >= 0 && ny >= 0 && nx < n && ny < m && mapa[nx][ny] == '.' && xmapa[nx][ny] == inf) {
                xmapa[nx][ny] = xmapa[x][y] + 1;
                vatra.push(make_pair(nx, ny));
            }
        }
    }
}

void BFS_steva(vector<vector<char>>& mapa, vector<vector<int>>& smapa, vector<vector<int>>& xmapa, queue<pair<int, int>>& steva){
    int n = mapa.size();
    int m = mapa[0].size();
    while (!steva.empty()) {
        int x = steva.front().first;
        int y = steva.front().second;
        steva.pop();
        for (int i = 0; i < 4; i++) {
            int nx = x + dir[i];
            int ny = y + dir[i + 1];
            if (nx >= 0 && ny >= 0 && nx < n && ny < m && mapa[nx][ny] == '.' && smapa[nx][ny] == inf && smapa[x][y] + 1 < xmapa[nx][ny]) {
                smapa[nx][ny] = smapa[x][y] + 1;
                steva.push(make_pair(nx, ny));
            }
        }
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n, m;
    cin >> n >> m;
    vector<vector<char>> mapa(n, vector<char>(m));
    queue<pair<int, int>> vatra, steva;
    pair<int, int> stevapoc;
    vector<vector<int>> xmapa(n, vector<int>(m, inf));
    vector<vector<int>> smapa(n, vector<int>(m, inf));
    for(int i = 0; i < n; i++){
        string s;
        cin >> s;
        for(int j = 0; j < m; j++){
            mapa[i][j] = s[j];
            if(s[j] == 'X'){
                vatra.push(make_pair(i, j));
                xmapa[i][j] = 0;
            }
            if(s[j] == 'S'){
                stevapoc = make_pair(i, j);
                steva.push(stevapoc);
                smapa[i][j] = 0;
            }
        }
    }

    BFS_vatra(mapa, xmapa, vatra);
    BFS_steva(mapa, smapa, xmapa, steva);

    int br = 1;
    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            if(mapa[i][j] == '.' && smapa[i][j] < xmapa[i][j]){
                br++;
            }
        }
    }
    cout << br << "\n";
    return 0;
}