#include <iostream>
#include <vector>
#include <queue>
using namespace std;

const int GLUPI_C[4] = {-1, 1, 0, 0};
const int DEBILNI_D[4] = {0, 0, -1, 1};

struct JEBENI_POZ {
    int x, y;
};

bool KOJI_IDIOT(int x, int y, int rows, int cols) {
    return x >= 0 && x < rows && y >= 0 && y < cols;
}

void PREBACI(vector<vector<char>>& mreza, vector<vector<int>>& udaljenosti, int rows, int cols) {
    queue<JEBENI_POZ> q;

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            if (mreza[i][j] == 'X') {
                q.push({i, j});
                udaljenosti[i][j] = 0;
            } else if (mreza[i][j] == '.' || mreza[i][j] == 'S') {
                udaljenosti[i][j] = -1;
            }
        }
    }

    while (!q.empty()) {
        JEBENI_POZ trenutna = q.front();
        q.pop();

        for (int i = 0; i < 4; i++) {
            int noviX = trenutna.x + GLUPI_C[i];
            int noviY = trenutna.y + DEBILNI_D[i];

            if (KOJI_IDIOT(noviX, noviY, rows, cols) && udaljenosti[noviX][noviY] == -1 && mreza[noviX][noviY] != '*') {
                udaljenosti[noviX][noviY] = udaljenosti[trenutna.x][trenutna.y] + 1;
                q.push({noviX, noviY});
            }
        }
    }
}

int PRAVAC(vector<vector<char>>& mreza, vector<vector<int>>& udaljenosti, int rows, int cols, JEBENI_POZ pocetak) {
    queue<JEBENI_POZ> q;
    vector<vector<int>> poseteno(rows, vector<int>(cols, -1));
    vector<vector<bool>> obrada(rows, vector<bool>(cols, false));

    q.push(pocetak);
    poseteno[pocetak.x][pocetak.y] = 0;
    obrada[pocetak.x][pocetak.y] = true;

    int brojac = 0;

    while (!q.empty()) {
        JEBENI_POZ trenutna = q.front();
        q.pop();

        if (udaljenosti[trenutna.x][trenutna.y] == -1 || udaljenosti[trenutna.x][trenutna.y] > poseteno[trenutna.x][trenutna.y]) {
            brojac++;
        }

        for (int i = 0; i < 4; i++) {
            int noviX = trenutna.x + GLUPI_C[i];
            int noviY = trenutna.y + DEBILNI_D[i];

            if (KOJI_IDIOT(noviX, noviY, rows, cols) && !obrada[noviX][noviY] &&
                (mreza[noviX][noviY] == '.' || mreza[noviX][noviY] == 'S') &&
                (poseteno[noviX][noviY] == -1 || poseteno[noviX][noviY] > poseteno[trenutna.x][trenutna.y] + 1) &&
                (udaljenosti[noviX][noviY] == -1 || udaljenosti[noviX][noviY] > poseteno[trenutna.x][trenutna.y] + 1)) {
                obrada[noviX][noviY] = true;
                poseteno[noviX][noviY] = poseteno[trenutna.x][trenutna.y] + 1;
                q.push({noviX, noviY});
            }
        }
    }

    return brojac;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int KRTINA, NBGD;
    cin >> KRTINA >> NBGD;

    vector<vector<char>> nucci(KRTINA, vector<char>(NBGD));
    vector<vector<int>> voice(KRTINA, vector<int>(NBGD));

    JEBENI_POZ pocetak;

    for (int i = 0; i < KRTINA; i++) {
        for (int j = 0; j < NBGD; j++) {
            cin >> nucci[i][j];
            if (nucci[i][j] == 'S') {
                pocetak = {i, j};
            }
        }
    }

    PREBACI(nucci, voice, KRTINA, NBGD);

    int rezultat = PRAVAC(nucci, voice, KRTINA, NBGD, pocetak);

    cout << rezultat << endl;

    return 0;
}