#include <iostream>
#include <deque>

using namespace std;

int N, M;
char mt[1000][1000];
int ms[1000][1000];

constexpr char STEVA = 'S', SLOBODNO = '.', ZID = '*', VATRA = 'X';

struct Move {
    int x, y;
    int steps;
    char type;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    cin >> N >> M;
    deque<Move> q;

    for (int i = 0; i < N; i += 1) {
        for (int j = 0; j < M; j += 1) {
            cin >> mt[i][j];
            ms[i][j] = INT_MAX;
            if (mt[i][j] == STEVA) {
                q.push_back({i, j, 0, mt[i][j]});
            }
            else if (mt[i][j] == VATRA) {
                q.push_front({i, j, 0, mt[i][j]});
            }
        }
    }

    while (!q.empty()) {
        Move m = q.front();
        q.pop_front();

        int x = m.x, y = m.y;

        if (mt[x][y] == ZID ||
            ms[x][y] < m.steps ||
            (ms[x][y] == m.steps && !(mt[x][y] == STEVA && m.type == VATRA))) {
            continue;
        }

        mt[x][y] = m.type;
        ms[x][y] = m.steps;

        if (x + 1 < N) {
            q.push_back({x + 1, y, m.steps + 1, m.type});
        }
        if (x - 1 >= 0) {
            q.push_back({x - 1, y, m.steps + 1, m.type});
        }
        if (y + 1 < M) {
            q.push_back({x, y + 1, m.steps + 1, m.type});
        }
        if (y - 1 >= 0) {
            q.push_back({x, y - 1, m.steps + 1, m.type});
        }
    }

    int counter = 0;
    for (int i = 0; i < N; i += 1) {
        for (int j = 0; j < M; j += 1) {
            if (mt[i][j] == STEVA) {
                counter += 1;
            }
        }
    }
    cout << counter << endl;

    return 0;
}