using System;
using System.Linq;

class Program
{
    static void Main()
    {

        var firstLine = Console.ReadLine().Split().Select(long.Parse).ToArray();
        int N = (int)firstLine[0];  
        int Q = (int)firstLine[1];  
        
        var purchases = new (long day, long count)[N];
        for (int i = 0; i < N; i++)
        {
            var data = Console.ReadLine().Split().Select(long.Parse).ToArray();
            purchases[i] = (data[0], data[1]);
        }

        var questions = new long[Q];
        for (int i = 0; i < Q; i++)
        {
            questions[i] = long.Parse(Console.ReadLine());
        }

        var sortedQuestions = questions.Select((k, idx) => (k, idx)).OrderBy(q => q.k).ToArray();

        long total = 0;
        int purchaseIndex = 0;
        long[] answers = new long[Q];
        
        foreach (var (k, originalIdx) in sortedQuestions)
        {
            while (purchaseIndex < N && purchases[purchaseIndex].day <= k)
            {
                total += purchases[purchaseIndex].count;
                purchaseIndex++;
            }
            answers[originalIdx] = total;
        }
        foreach (var answer in answers)
        {
            Console.WriteLine(answer);
        }
    }
}