#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main() {
    int brojKupovina, brojPitanja;
    cin >> brojKupovina >> brojPitanja;

    vector<pair<int, int>> kupovine(brojKupovina);
    for (int i = 0; i < brojKupovina; i++) {
        cin >> kupovine[i].first >> kupovine[i].second;
    }

    vector<int> pitanja(brojPitanja);
    for (int i = 0; i < brojPitanja; i++) {
        cin >> pitanja[i];
    }

    int maksDan = 0;
    for (const auto& kupovina : kupovine) {
        maksDan = max(maksDan, kupovina.first);
    }
    for (const auto& pitanje : pitanja) {
        maksDan = max(maksDan, pitanje);
    }

    vector<int> plazma(maksDan + 1, 0);
    for (const auto& kupovina : kupovine) {
        plazma[kupovina.first] += kupovina.second;
    }

    vector<int> dostupna(maksDan + 1, 0);
    for (int dan = 1; dan <= maksDan; dan++) {
        dostupna[dan] = dostupna[dan - 1] + plazma[dan];
    }

    vector<int> pojedena(maksDan + 1, 0);
    for (int dan = 1; dan <= maksDan; dan++) {
        if (dostupna[dan] > pojedena[dan - 1]) {
            pojedena[dan] = pojedena[dan - 1] + 1;
        } else {
            pojedena[dan] = pojedena[dan - 1];
        }
    }

    for (const auto& danPitanja : pitanja) {
        cout << pojedena[danPitanja] << endl;
    }

    return 0;
}