#include <stdio.h>
#include <stdlib.h>

#define MOD 1000000007

long long min(long long a, long long b) {
    return a < b ? a : b;
}

int main() {
    long long N, Q, i, j;

    scanf("%lld %lld", &N, &Q);

    long long *d = (long long *)malloc((N + 1) * sizeof(long long));
    long long *p = (long long *)malloc((N + 1) * sizeof(long long));
    long long *k = (long long *)malloc((Q + 1) * sizeof(long long));
    long long *doDana = (long long *)malloc((N + 1) * sizeof(long long));

    for (i = 1; i <= N; i++) {
        scanf("%lld %lld", &d[i], &p[i]);
    }

    doDana[0] = 0;
    for (i = 1; i <= N; i++) {
        doDana[i] = (doDana[i - 1] + p[i]) % MOD;
    }

    for (j = 1; j <= Q; j++) {
        scanf("%lld", &k[j]);
    }

    for (j = 1; j <= Q; j++) {
        long long day = k[j];
        long long total_eaten = 0;

        long long low = 1, high = N, mid, last_valid = 0;
        while (low <= high) {
            mid = (low + high) / 2;
            if (d[mid] <= day) {
                last_valid = mid;
                low = mid + 1;
            } else {
                high = mid - 1;
            }
        }

        if (last_valid > 0) {
            total_eaten = doDana[last_valid];
        }

        long long days_eaten = min(day, total_eaten);

        printf("%lld\n", days_eaten % MOD);
    }

    free(d);
    free(p);
    free(k);
    free(doDana);

    return 0;
}