using System;

class PlazmaProblem
{
    static void Main(string[] args)
    {
        string[] consoleLinija = Console.ReadLine().Split();
        int N = int.Parse(consoleLinija[0]);
        int Q = int.Parse(consoleLinija[1]);

        long[] dani = new long[N];
        long[] kolicina = new long[N];
        long[] prefixSum = new long[N];

        for (int i = 0; i < N; i++)
        {
            string[] purchaseLine = Console.ReadLine().Split();
            dani[i] = long.Parse(purchaseLine[0]);
            kolicina[i] = long.Parse(purchaseLine[1]);
            prefixSum[i] = kolicina[i] + (i > 0 ? prefixSum[i - 1] : 0);
        }

        long[] upiti = new long[Q];
        for (int i = 0; i < Q; i++)
        {
            upiti[i] = long.Parse(Console.ReadLine());
        }

        foreach (var upit in upiti)
        {
            int levo = 0, desno = N - 1, validanIndex = -1;
            while (levo <= desno)
            {
                int mid = levo + (desno - levo) / 2;
                if (dani[mid] <= upit)
                {
                    validanIndex = mid;
                    levo = mid + 1;
                }
                else
                {
                    desno = mid - 1;
                }
            }

            if (validanIndex == -1)
            {
                Console.WriteLine(0);
                continue;
            }

            long ukupnaPlazma = prefixSum[validanIndex];
            long pocetniDan = dani[0];
            long dostupniDani = Math.Max(0, upit - pocetniDan + 1);

            Console.WriteLine(Math.Min(ukupnaPlazma, dostupniDani));
        }
    }
}