#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

struct Kupovina {
    long long dan;
    long long brojPaketa;
    Kupovina(long long d, long long p) : dan(d), brojPaketa(p) {}
};

long long izracunajPojedenePakete(vector<Kupovina>& kupovine, long long krajnjiDan) {
    long long ukupnoPojedeno = 0;
    long long dostupniPaketi = 0;
    long long trenutniDan = kupovine[0].dan;
    int indeksKupovine = 0;

    while (trenutniDan <= krajnjiDan && indeksKupovine < kupovine.size()) {
        if (trenutniDan == kupovine[indeksKupovine].dan) {
            dostupniPaketi += kupovine[indeksKupovine].brojPaketa;
            indeksKupovine++;
        }

        if (dostupniPaketi > 0) {
            ukupnoPojedeno++;
            dostupniPaketi--;
        }

        trenutniDan++;

        if (dostupniPaketi == 0 && indeksKupovine >= kupovine.size())
            break;
    }

    if (trenutniDan <= krajnjiDan && dostupniPaketi > 0) {
        long long preostaliDani = min(dostupniPaketi, krajnjiDan - trenutniDan + 1);
        ukupnoPojedeno += preostaliDani;
    }

    return ukupnoPojedeno;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    long long brojKupovina, brojUpita;
    cin >> brojKupovina >> brojUpita;

    vector<Kupovina> kupovine;
    for (int i = 0; i < brojKupovina; i++) {
        long long dan, paketi;
        cin >> dan >> paketi;
        kupovine.push_back(Kupovina(dan, paketi));
    }

    vector<long long> upiti;
    for (int i = 0; i < brojUpita; i++) {
        long long k;
        cin >> k;
        upiti.push_back(k);
    }

    for (long long krajnjiDan : upiti) {
        cout << izracunajPojedenePakete(kupovine, krajnjiDan) << '\n';
    }

    return 0;
}