#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

const long long MOD = 1000000000000000000;

int main() {
    int N, Q;
    cin >> N >> Q;
    vector<pair<int, long long>> kupovine(N);
    for (int i = 0; i < N; i++) {
        cin >> kupovine[i].first >> kupovine[i].second;
    }
    vector<long long> pitanja(Q);
    for (int i = 0; i < Q; i++) {
        cin >> pitanja[i];
    }
    sort(kupovine.begin(), kupovine.end());
    sort(pitanja.begin(), pitanja.end());
    vector<long long> odgovori(Q);
    long long ukupno_kupljeno = 0;   
    long long ukupno_pojedeno = 0;  
    int trenutni_dan = 1;           
    int kupovina_idx = 0;           
    for (int i = 0; i < Q; i++) {
        long long cilj_dan = pitanja[i];
        while (kupovina_idx < N && kupovine[kupovina_idx].first <= cilj_dan) {
            int dan_kupovine = kupovine[kupovina_idx].first;
            long long kolicina = kupovine[kupovina_idx].second;
            if (trenutni_dan < dan_kupovine) {
                long long dana_proslo = dan_kupovine - trenutni_dan;
                long long pojesti = min(dana_proslo, ukupno_kupljeno);
                ukupno_pojedeno = (ukupno_pojedeno + pojesti) % MOD;
                ukupno_kupljeno -= pojesti;
            }
            ukupno_kupljeno = (ukupno_kupljeno + kolicina) % MOD;
            trenutni_dan = dan_kupovine;
            kupovina_idx++;
        }
        if (trenutni_dan <= cilj_dan) {
            long long dana_proslo = cilj_dan - trenutni_dan + 1;
            long long pojesti = min(dana_proslo, ukupno_kupljeno);

            ukupno_pojedeno = (ukupno_pojedeno + pojesti) % MOD;
            ukupno_kupljeno -= pojesti;
            trenutni_dan = cilj_dan + 1;
        }
        odgovori[i] = ukupno_pojedeno;
    }
    for (long long odgovor : odgovori) {
        cout << odgovor << endl;
    }

    return 0;
}