#include <bits/stdc++.h>
#define ll long long
#define endl '\n'
#define MAXN 1010
#define pii pair<ll,ll>

using namespace std;

ll N, M;
vector < vector <char> > graf(MAXN, vector <char> (MAXN));
vector < vector <ll> > dist_fire(MAXN, vector <ll> (MAXN, 2e18));
vector < vector <ll> > dist_steve(MAXN, vector <ll> (MAXN, 2e18));
vector < vector <bool> > vis1(MAXN, vector <bool> (MAXN));
vector < vector <bool> > vis2(MAXN, vector <bool> (MAXN));
vector <ll> dx = {0, 0, 1, -1};
vector <ll> dy = {1, -1, 0, 0};
queue <pii> q1, q2;

bool in_bounds(ll X, ll Y) {return(X >= 0 && X < N && Y >= 0 && Y < M && graf[X][Y] != '*');}

void BFS(vector <vector <ll> >& dist, queue <pii>& q, vector < vector <bool> >& vis)
{
    while(q.size())
    {
        ll X = q.front().first;
        ll Y = q.front().second;
        q.pop();
        for(int i = 0; i < 4; i++)
        {
            ll nX = X + dx[i];
            ll nY = Y + dy[i];
            if(in_bounds(nX, nY) && !vis[nX][nY])
            {
                q.push({nX, nY});
                vis[nX][nY] = true;
                dist[nX][nY] = dist[X][Y] + 1;
            }
        }
    }
}


int main()
{
    ios_base::sync_with_stdio(false); cin.tie(0);
    ll stX, stY, fX, fY, res = 0;
    cin >> N >> M;
    for(int i = 0; i < N; i++)
    {
        string s;
        cin >> s;
        for(int j = 0; j < M; j++) graf[i][j] = s[j];
    }
    for(int i = 0; i < N; i++)
    {
        for(int j = 0; j < M; j++)
        {
            if(graf[i][j] == 'S') {q1.push({i, j}); vis1[i][j] = true; dist_steve[i][j] = 0;}
            if(graf[i][j] == 'X') {q2.push({i, j}); vis2[i][j] = true; dist_fire[i][j] = 0;}
        }
    }
    BFS(dist_fire, q2, vis2);
    BFS(dist_steve, q1, vis1);
    for(int i = 0; i < N; i++) {for(int j = 0; j < M; j++) if(dist_steve[i][j] < dist_fire[i][j]) res++;}
    cout << res << endl;
    return 0;
}