#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int N, Q;

struct danPak {
	long long dan, pak;
};

int pretraga(const vector<danPak>& parovi, long long x) {
    int low = 0, high = parovi.size() - 1, rezultat = -1;
    while (low <= high) {
        int mid = low + (high - low) / 2;
        if (parovi[mid].dan <= x) {
            rezultat = mid;
            low = mid + 1;
        }
        else {
            high = mid - 1;
        }
    }
    return rezultat;
}

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	long long int N, Q;
	cin >> N >> Q;

    vector<danPak> parovi(N);
    for (int i = 0; i < N; ++i) {
        cin >> parovi[i].dan >> parovi[i].pak;
    }

    vector<long long> upiti(Q);
    for (int i = 0; i < Q; i++) {
        cin >> upiti[i];
    }

    vector<long long> sume(N);
    sume[0] = parovi[0].pak;
    for (int i = 1; i < N; ++i) {
        sume[i] = sume[i - 1] + parovi[i].pak;
    }

    for (int i = 0; i < Q; ++i) {
        long long k = upiti[i];
        int indeks = pretraga(parovi, k);
        if (indeks == -1) {
            cout << 0 << endl;
        }
        else {
            long long ukupnoPakovanja = sume[indeks];
            long long danaPojeo = k - parovi[0].dan + 1;

            cout << min(ukupnoPakovanja, danaPojeo) << endl;
        }
    }
}