using System;
using System.Collections.Generic;
using System.Linq;

namespace Petlja
{
    internal class Program
    {
        static void Main()
        {
            string[] firstInput = (Console.ReadLine() ?? "0 0").Split(' ');
            int Days = int.Parse(firstInput[0]);
            int Questions = int.Parse(firstInput[1]);

            List<(long day, long production)> ShoppingSchedule = new List<(long day, long production)>();
            List<long> queries = new List<long>();

            for (int i = 0; i < Days; i++)
            {
                string[] dayInput = (Console.ReadLine() ?? "0 0").Split(' ');
                ShoppingSchedule.Add((long.Parse(dayInput[0]), long.Parse(dayInput[1])));
            }

            for (int i = 0; i < Questions; i++)
            {
                queries.Add(long.Parse(Console.ReadLine() ?? "0"));
            }

            foreach (long queryDay in queries)
            {
                ProcessQuery(queryDay, ShoppingSchedule);
            }
        }

        private static void ProcessQuery(long TargetDay, List<(long day, long production)> schedule)
        {
            long availableFood = 0;
            long totalEatenFood = 0;
            long lastProcessedDay = 0;

            var adjustedSchedule = schedule
                .Where(entry => entry.day < TargetDay)
                .Append((TargetDay + 1, 0L));

            foreach ((long currentDay, long dailyProduction) in adjustedSchedule)
            {
                long elapsedDays = currentDay - lastProcessedDay;

                if (availableFood >= elapsedDays)
                {
                    availableFood -= elapsedDays;
                    totalEatenFood += elapsedDays;
                }
                else
                {
                    totalEatenFood += availableFood;
                    availableFood = 0;
                }

                availableFood += dailyProduction;
                lastProcessedDay = currentDay;
            }

            Console.WriteLine(totalEatenFood);
        }
    }
}