import java.util.LinkedList;
import java.util.Queue;
import java.util.Scanner;
public class Main {
    static final int[] pomX = {-1, 1, 0, 0};
    static final int[] pomY = {0, 0, -1, 1};
    public static void main(String[] args) {
        Scanner ulaz = new Scanner(System.in);
        int n = ulaz.nextInt();
        int m = ulaz.nextInt();
        char[][] mat = new char[n][m];
        ulaz.nextLine();
        //unosi se lavirint
        for (int i = 0; i < n; i++) {
            String red = ulaz.nextLine();
            mat[i] = red.toCharArray();
        }
        //vreme vatre
        int[][] vv = new int[n][m];
        //vreme Steve
        int[][] vs = new int[n][m];
        //pocetne pozicije za Stevu(S)
        int psx = -1, psy = -1;
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                vv[i][j] = Integer.MAX_VALUE;
                vs[i][j] = Integer.MAX_VALUE;
            }
        }
        //postavljanje pocetnih pozicija
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                if (mat[i][j] == 'S') {
                    psx = i;
                    psy = j;
                    vs[i][j] = 0;
                } else if (mat[i][j] == 'X') {
                    vv[i][j] = 0;
                }
            }
        }
        //koristi se funkc. za vatru
        bfsVatra(vv, mat, n, m);
        //koristi se funkc. za stevu
        bfsSteva(vs, mat, n, m, psx, psy);
        //brojanje koliko polja steva moze da uzme
        int b = 0;
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                if (mat[i][j] == '.' && vs[i][j] < vv[i][j]) {
                    b++;
                }
            }
        }
        b++;
        System.out.println(b);
    }
    //funkcija za vatru
    private static void bfsVatra(int[][] vv, char[][] mat, int n, int m) {
        Queue<int[]> q = new LinkedList<>();
        
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                if (vv[i][j] == 0) {
                    q.add(new int[] {i, j});
                }
            }
        }

        while (!q.isEmpty()) {
            int[] tren = q.poll();
            int x = tren[0];
            int y = tren[1];

            for (int i = 0; i < 4; i++) {
                int nx = x + pomX[i], ny = y + pomY[i];

                if (nx >= 0 && nx < n && ny >= 0 && ny < m && mat[nx][ny] == '.' && vv[nx][ny] == Integer.MAX_VALUE) {
                    vv[nx][ny] = vv[x][y] + 1;
                    q.add(new int[] {nx, ny});
                }
            }
        }
    }

    //funkcija za Stevu
    private static void bfsSteva(int[][] vs, char[][] mat, int n, int m, int psx, int psy) {
        Queue<int[]> q = new LinkedList<>();
        q.add(new int[] {psx, psy});
        vs[psx][psy] = 0;

        while (!q.isEmpty()) {
            int[] tren = q.poll();
            int x = tren[0];
            int y = tren[1];

            for (int i = 0; i < 4; i++) {
                int nx = x + pomX[i], ny = y + pomY[i];

                if (nx >= 0 && nx < n && ny >= 0 && ny < m && mat[nx][ny] == '.' && vs[nx][ny] == Integer.MAX_VALUE) {
                    vs[nx][ny] = vs[x][y] + 1;
                    q.add(new int[] {nx, ny});
                }
            }
        }
    }
}