#include <bits/stdc++.h>

using namespace std;
bool jeLiMoguce(int x, int y, int n, int m, vector<string> mapa)
{
    if (x < 0 || x >= n || y < 0 || y >= m)
        return 0;
    if (mapa[x][y] == '*')
        return 0;
    return 1;
}

int resi(int n, int m, vector<string> mapa)
{
    int dx[] = {0, 0, 1, -1};
    int dy[] = {1, -1, 0, 0};
    vector<vector<int>> vreme_vatre(n, vector<int>(m, INT_MAX));
    vector<vector<int>> vreme_steve(n, vector<int>(m, INT_MAX));
    queue<pair<int, int>> vatra_kju;
    queue<pair<int, int>> steva_kju;
    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < m; j++)
        {
            if (mapa[i][j] == 'X')
            {
                vatra_kju.push({i, j});
                vreme_vatre[i][j] = 0;
            }
            if (mapa[i][j] == 'S')
            {
                steva_kju.push({i, j});
                vreme_steve[i][j] = 0;
            }
        }
    }
    while (!vatra_kju.empty())
    {
        auto [x, y] = vatra_kju.front();
        vatra_kju.pop();
        for (int i = 0; i < 4; i++)
        {
            int nx = x + dx[i];
            int ny = y + dy[i];
            if (jeLiMoguce(nx, ny, n, m, mapa) && vreme_vatre[nx][ny] == INT_MAX)
            {
                vreme_vatre[nx][ny] = vreme_vatre[x][y] + 1;
                vatra_kju.push({nx, ny});
            }
        }
    }
    int res = 0;
    while (!steva_kju.empty())
    {
        auto [x, y] = steva_kju.front();
        steva_kju.pop();
        for (int i = 0; i < 4; i++)
        {
            int nx = x + dx[i];
            int ny = y + dy[i];
            if (jeLiMoguce(nx, ny, n, m, mapa) && vreme_steve[nx][ny] == INT_MAX && vreme_steve[x][y] + 1 < vreme_vatre[nx][ny])
            {
                vreme_steve[nx][ny] = vreme_steve[x][y] + 1;
                steva_kju.push({nx, ny});
            }
        }
    }
    for (int i = 0; i < n; i++)
    {
        for (int j = 0; j < m; j++)
        {
            if (vreme_steve[i][j] < vreme_vatre[i][j] && vreme_steve[i][j] != INT_MAX)
            {
                res++;
            }
        }
    }
    return res;
}
int main()
{
    int n, m;
    cin >> n >> m;
    vector<string> mapa(n);
    for (int i = 0; i < n; i++)
    {
        cin >> mapa[i];
    }
    cout << resi(n, m, mapa) << endl;
    return 0;
}