#include <iostream>
#include <vector>

void prosiri(int x, int y, std::vector<std::vector<char>>& matrica, std::vector<std::pair<int, int>>& niz, char c, int& zbir)
{
    int h = (int)matrica.size();
    int w = (int)matrica[0].size();
    
    if (matrica[y][x] != 'X' && matrica[y][x] != 'S')
    {
        if (c == 'S' && matrica[y][x] != 'S')
            zbir++;
        
        matrica[y][x] = c;
    }
    
    if (x - 1 >= 0 && y >= 0 && x - 1 < w && y < h)
        if (matrica[y][x - 1] != 'X' && matrica[y][x - 1] != 'S' && matrica[y][x - 1] != '*')
            niz.push_back({ x - 1, y });
    if (x + 1 >= 0 && y >= 0 && x + 1 < w && y < h)
        if (matrica[y][x + 1] != 'X' && matrica[y][x + 1] != 'S' && matrica[y][x + 1] != '*')
            niz.push_back({ x + 1, y });
    if (x >= 0 && y - 1 >= 0 && x < w && y - 1 < h)
        if (matrica[y - 1][x] != 'X' && matrica[y - 1][x] != 'S' && matrica[y - 1][x] != '*')
            niz.push_back({ x, y - 1 });
    if (x >= 0 && y + 1 >= 0 && x < w && y + 1 < h)
        if (matrica[y + 1][x] != 'X' && matrica[y + 1][x] != 'S' && matrica[y + 1][x] != '*')
            niz.push_back({ x, y + 1 });
}

int main()
{
    int n = 0;
    int m = 0;
    std::cin >> n >> m;
    
    std::vector<std::vector<char>> matrica(n, std::vector<char>(m));
    
    std::vector<std::pair<int, int>> vatra;
    std::vector<std::pair<int, int>> stevo;
    
    for (int y = 0; y < n; y++)
    {
        for (int x = 0; x < m; x++)
        {
            std::cin >> matrica[y][x];
            if (matrica[y][x] == 'X')
            {
                vatra.push_back({ x, y });
                matrica[y][x] = '.';
            }
            else if (matrica[y][x] == 'S')
            {
                stevo.push_back({ x, y });
                matrica[y][x] = '.';
            }
        }
    }
    
    int zbir = 0;
    
    while (stevo.size() > 0)
    {
        std::vector<std::pair<int, int>> tempV = vatra;
        std::vector<std::pair<int, int>> tempS = stevo;
        
        vatra.clear();
        stevo.clear();
        
        for (std::pair<int, int> e : tempV)
            prosiri(e.first, e.second, matrica, vatra, 'X', zbir);
        for (std::pair<int, int> e : tempS)
            prosiri(e.first, e.second, matrica, stevo, 'S', zbir);
    }
    
    std::cout << zbir << std::endl;
}