#include <iostream>
using namespace std;

// Funkcija za prebrojavanje karaktera u matrici
int brojPojava(char *polje, int visina, int sirina, char target) {
    int ukupanBroj = 0;
    for (int red = 0; red < visina; red++) {
        for (int kol = 0; kol < sirina; kol++) {
            if (*(polje + red * sirina + kol) == target) {
                ukupanBroj++;
            }
        }
    }
    return ukupanBroj;
}

// Funkcija za sirenje matrice
bool azurirajPolje(char *polje, int visina, int sirina, char aktivni, char neaktivni) {
    bool promenjeno = false;
    char privremeno[visina][sirina];

    // kopiranje u matricu
    for (int red = 0; red < visina; red++) {
        for (int kol = 0; kol < sirina; kol++) {
            privremeno[red][kol] = *(polje + red * sirina + kol);
        }
    }

    // sirenje aktivnog karaktera
    for (int red = 0; red < visina; red++) {
        for (int kol = 0; kol < sirina; kol++) {
            if (*(polje + red * sirina + kol) == aktivni) {
                // proveravanje susednog polja
                if (kol > 0 && privremeno[red][kol - 1] != '*' && privremeno[red][kol - 1] != aktivni && privremeno[red][kol - 1] != neaktivni) {
                    privremeno[red][kol - 1] = aktivni;
                    promenjeno = true;
                }
                if (kol < sirina - 1 && privremeno[red][kol + 1] != '*' && privremeno[red][kol + 1] != aktivni && privremeno[red][kol + 1] != neaktivni) {
                    privremeno[red][kol + 1] = aktivni;
                    promenjeno = true;
                }
                if (red > 0 && privremeno[red - 1][kol] != '*' && privremeno[red - 1][kol] != aktivni && privremeno[red - 1][kol] != neaktivni) {
                    privremeno[red - 1][kol] = aktivni;
                    promenjeno = true;
                }
                if (red < visina - 1 && privremeno[red + 1][kol] != '*' && privremeno[red + 1][kol] != aktivni && privremeno[red + 1][kol] != neaktivni) {
                    privremeno[red + 1][kol] = aktivni;
                    promenjeno = true;
                }
            }
        }
    }

    // Azuriranje matrice
    for (int red = 0; red < visina; red++) {
        for (int kol = 0; kol < sirina; kol++) {
            *(polje + red * sirina + kol) = privremeno[red][kol];
        }
    }

    return promenjeno;
}

int main() {
    int visina, sirina;
    cin >> visina >> sirina;

    char mreza[visina][sirina];

    // Ucitavanje mreze
    for (int red = 0; red < visina; red++) {
        for (int kol = 0; kol < sirina; kol++) {
            cin >> mreza[red][kol];
        }
    }

    // ?????? ????????? ??? ??? ???????
    while (azurirajPolje(&mreza[0][0], visina, sirina, 'X', 'S') || azurirajPolje(&mreza[0][0], visina, sirina, 'S', 'X')) {}

    // Ispis broja ponavljanja karaktera 'S'
    cout << brojPojava(&mreza[0][0], visina, sirina, 'S') << endl;

    return 0;
}