#include <iostream>
using namespace std;

// Funkcija za prebrojavanje
int prebrojKaraktere(char *matrica, int visina, int sirina, char cilj) {
    int ukupanBroj = 0;
    for (int red = 0; red < visina; red++) {
        for (int kol = 0; kol < sirina; kol++) {
            if (*(matrica + red * sirina + kol) == cilj) {
                ukupanBroj++;
            }
        }
    }
    return ukupanBroj;
}

// Funkcija za sirenje karaktera
bool prosiriMatricu(char *matrica, int visina, int sirina, char aktivni, char neaktivni) {
    bool promenjeno = false;

    // Oznacavanje celija
    for (int red = 0; red < visina; red++) {
        for (int kol = 0; kol < sirina; kol++) {
            if (*(matrica + red * sirina + kol) == aktivni) {
                // provera susednih celija
                if (kol > 0 && *(matrica + red * sirina + (kol - 1)) != '*' &&
                    *(matrica + red * sirina + (kol - 1)) != aktivni &&
                    *(matrica + red * sirina + (kol - 1)) != neaktivni) {
                    *(matrica + red * sirina + (kol - 1)) = 'A';
                    promenjeno = true;
                }
                if (kol < sirina - 1 && *(matrica + red * sirina + (kol + 1)) != '*' &&
                    *(matrica + red * sirina + (kol + 1)) != aktivni &&
                    *(matrica + red * sirina + (kol + 1)) != neaktivni) {
                    *(matrica + red * sirina + (kol + 1)) = 'A';
                    promenjeno = true;
                }
                if (red > 0 && *(matrica + (red - 1) * sirina + kol) != '*' &&
                    *(matrica + (red - 1) * sirina + kol) != aktivni &&
                    *(matrica + (red - 1) * sirina + kol) != neaktivni) {
                    *(matrica + (red - 1) * sirina + kol) = 'A';
                    promenjeno = true;
                }
                if (red < visina - 1 && *(matrica + (red + 1) * sirina + kol) != '*' &&
                    *(matrica + (red + 1) * sirina + kol) != aktivni &&
                    *(matrica + (red + 1) * sirina + kol) != neaktivni) {
                    *(matrica + (red + 1) * sirina + kol) = 'A';
                    promenjeno = true;
                }
            }
        }
    }

    // Zamena karaktera sa 'A'
    for (int red = 0; red < visina; red++) {
        for (int kol = 0; kol < sirina; kol++) {
            if (*(matrica + red * sirina + kol) == 'A') {
                *(matrica + red * sirina + kol) = aktivni;
            }
        }
    }

    return promenjeno;
}

int main() {
    int visina, sirina;
    cin >> visina >> sirina;

    char mreza[visina][sirina];

    // ucitavanje mreze
    for (int red = 0; red < visina; red++) {
        for (int kol = 0; kol < sirina; kol++) {
            cin >> mreza[red][kol];
        }
    }

    // Sirenje karaktera
    while (prosiriMatricu(&mreza[0][0], visina, sirina, 'X', 'S') ||
           prosiriMatricu(&mreza[0][0], visina, sirina, 'S', 'X')) {}

    // Ispis broja 'S'
    cout << prebrojKaraktere(&mreza[0][0], visina, sirina, 'S') << endl;

    return 0;
}