from collections import deque

def bfs(start_points, N, M, grid):
    time = [[-1] * M for _ in range(N)]
    queue = deque(start_points)
    
    for (x, y, t) in start_points:
        time[x][y] = t

    directions = [(-1, 0), (1, 0), (0, -1), (0, 1)]
    
    while queue:
        x, y, t = queue.popleft()
        
        for dx, dy in directions:
            nx, ny = x + dx, y + dy
            if 0 <= nx < N and 0 <= ny < M and grid[nx][ny] != '*' and time[nx][ny] == -1:
                time[nx][ny] = t + 1
                queue.append((nx, ny, t + 1))
    
    return time

def solve(N, M, grid):
    fire_start = []
    steva_start = None
    
    for i in range(N):
        for j in range(M):
            if grid[i][j] == 'X':
                fire_start.append((i, j, 0))
            elif grid[i][j] == 'S':
                steva_start = (i, j)
    
    fire_time = bfs(fire_start, N, M, grid)
    steva_time = bfs([(steva_start[0], steva_start[1], 0)], N, M, grid)
    
    result = 0
    for i in range(N):
        for j in range(M):
            if grid[i][j] == '.' or grid[i][j] == 'S':
                if steva_time[i][j] != -1 and (fire_time[i][j] == -1 or steva_time[i][j] < fire_time[i][j]):
                    result += 1

    return result

N, M = map(int, input().split())
grid = [list(input().strip()) for _ in range(N)]

print(solve(N, M, grid))