#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
#include <tuple>
using namespace std;
typedef long long ll;

vector<vector<int>> mat;

bool validno(int x, int y, int n, int m) {
    return (x >= 0 && x < n&& y >= 0 && y < m);
}
vector<vector<bool>> bfs(vector<vector<int>>& duzine, int vrednost) {
    int n = mat.size();
    int m = mat[0].size();
    vector<int> dX = { -1, 1, 0, 0 }, dY = { 0, 0, -1, 1 };
    vector<vector<bool>> posecen(n, vector<bool>(m, false));
    queue<tuple<int, int, int>> q;
    for (int i = 0; i < n; i++)
        for (int j = 0; j < m; j++)
            if (mat[i][j] == vrednost) {
                posecen[i][j] = true;
                q.push({ 0, i, j });
            }
    while (!q.empty()) {
        int x, y, d;
        tie(d, x, y) = q.front(); q.pop();
        duzine[x][y] = d;
        for (int i = 0; i < 4; i++) {
            int nX = x + dX[i];
            int nY = y + dY[i];

            if (validno(nX, nY, n, m) && !posecen[nX][nY] && mat[nX][nY] != -1) {
                posecen[nX][nY] = true;
                q.push({ d + 1, nX, nY });
            }
        }
    }
    return posecen;
}
int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);
    int n, m;
    cin >> n >> m;
    mat.resize(n, vector<int>(m, 0));
    vector<vector<int>> vatra(n, vector<int>(m, 0)), steva(n, vector<int>(m, 0));
    for (int i = 0; i < n; i++){ string a; cin >> a; for (int j = 0; j < a.size(); j++) { if (a[j] == '*') mat[i][j] = -1; else if (a[j] == 'X') mat[i][j] = 1; else if (a[j] == '.') mat[i][j] = 0; else mat[i][j] = 2; }}
    vector<vector<bool>> dVatra = bfs(vatra, 1);
    vector<vector<bool>> dSteva = bfs(steva, 2);
    int s = 0;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++)
            if ((steva[i][j] < vatra[i][j] && dVatra[i][j] && dSteva[i][j]) ||
                (dSteva[i][j] && !dVatra[i][j])) s++;
    }
    cout << s;
}