#include<bits/stdc++.h>
using namespace std;
#define MAXN 1003

vector<vector<char>> grid(MAXN, vector<char>(MAXN));
queue<pair<int,int>> q;
vector<vector<int>> stepenX(MAXN, vector<int>(MAXN, INT_MAX));
vector<vector<int>> stepenS(MAXN, vector<int>(MAXN, INT_MAX));
vector<vector<bool>> visitedX(MAXN, vector<bool>(MAXN, false));
vector<vector<bool>> visitedS(MAXN, vector<bool>(MAXN, false));

int n,m;
int neighborX[4] = { 0, 0, 1, -1 };
int neighborY[4] = { 1, -1, 0, 0 };


bool isValidX(int x, int y)
{
    if (x >= n)
        return false;
    if (y >= m)
        return false;
    if (x < 0)
        return false;
    if (y < 0)
        return false;
    if (grid[x][y] == '*')//zid
        return false;
    if(grid[x][y] == 'X')
        return false;
 
    return true;
}

void bfsX()
{
    pair<int,int> temp;

    while(!q.empty())
    {
        temp = q.front();
        q.pop();

        for(int i = 0; i < 4; i++)
        {
            int newX = temp.first + neighborX[i];
            int newY = temp.second + neighborY[i];
            if(isValidX(newX,newY) && !visitedX[newX][newY])
            {
                stepenX[newX][newY] = stepenX[temp.first][temp.second] + 1;
                visitedX[newX][newY] = true;
                q.emplace(newX,newY);
            }
        }
    }
}

pair<int,int> steva;
int cnt = 0;

void bfsS()
{
    pair<int,int> temp;
    queue<pair<int,int>> qs;
    qs.emplace(steva.first, steva.second);//krecemo sa stevine pozicije

    while(!qs.empty())
    {
        temp = qs.front();
        qs.pop();

        for(int i = 0; i < 4; i++)
        {
            int newX = temp.first + neighborX[i];
            int newY = temp.second + neighborY[i];
            if(isValidX(newX,newY) && !visitedS[newX][newY])
            {
                stepenS[newX][newY] = stepenS[temp.first][temp.second] + 1;
                if(stepenS[newX][newY] < stepenX[newX][newY])
                    cnt++;

                qs.emplace(newX,newY);
                visitedS[newX][newY] = true;
            }
        }
    }


}


int main()
{
    cin >> n >> m;
    for(int i = 0; i < n; i++)
    {
        for(int j = 0; j < m; j++)
        {
            char c;
            cin >> c;
            grid[i][j] = c;

            if(c == 'S')
            {
                steva.first = i;
                steva.second = j;
            }

            else if(c == 'X')
            {
                q.emplace(i,j);
            }        
        }
    }

    //pokrecemBFSzaVatru.

    bfsX();

    //pokrenemo za Stevu BFS

    bfsS();

    cout << cnt << endl;
}