#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

long long izracunajPojedeno(int brojKupovina, const vector<long long>& dani, const vector<long long>& paketi, long long doDana) 
{
    long long ukupnoPojedeno = 0;
    long long preostaloPaketa = 0;
    long long poslednjiDan = 0;

    for (int i = 0; i < brojKupovina; i++) 
    {
        if (dani[i] > doDana) break;

        preostaloPaketa += paketi[i];

        long long razlikaDana = dani[i] - poslednjiDan - 1;

        long long mozePojesti = min(preostaloPaketa, razlikaDana);
        ukupnoPojedeno += mozePojesti;
        preostaloPaketa -= mozePojesti;

        poslednjiDan = dani[i];
    }

    if (poslednjiDan < doDana) 
    {
        long long mozePojesti = min(preostaloPaketa, doDana - poslednjiDan);
        ukupnoPojedeno += mozePojesti;
    }

    return ukupnoPojedeno;
}

int main() 
{
    int brojKupovina, brojPitanja;
    cin >> brojKupovina >> brojPitanja;

    vector<long long> dani(brojKupovina), paketi(brojKupovina);
    for (int i = 0; i < brojKupovina; i++) 
    {
        cin >> dani[i] >> paketi[i];
    }

    vector<long long> pitanja(brojPitanja);
    for (int i = 0; i < brojPitanja; i++) 
    {
        cin >> pitanja[i];
    }

    for (int i = 0; i < brojPitanja; i++)
    {
        cout << izracunajPojedeno(brojKupovina, dani, paketi, pitanja[i]) << endl;
    }
}