#include <cstdio>
#include <iostream>
#include <queue>
#include <string>
#include <utility>
#include <vector>
using namespace std;

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(nullptr);

  int n, m;
  string input;
  cin >> n >> m;
  cin.ignore();

  vector<vector<int>> maze;
  vector<int> helper;
  queue<pair<int, int>> stevan;
  queue<pair<int, int>> fire;

  for (int i = 0; i < n; i++) {
    getline(cin, input);
    helper.clear();
    for (int j = 0; j < m; j++) {
      switch (input[j]) {
      case 'S':
        helper.push_back(5);
        stevan.push(make_pair(i, j));
        break;
      case 'X':
        helper.push_back(-1);
        fire.push(make_pair(i, j));
        break;
      case '*':
        helper.push_back(1);
        break;
      default:
        helper.push_back(0);
        break;
      }
    }
    maze.push_back(helper);
  }

  int curr_len;
  while (!stevan.empty()) {
    curr_len = fire.size();
    for (int i = 0; i < curr_len; i++) {
      auto pos = fire.front();
      if (pos.first > 0) {
        if (maze[pos.first - 1][pos.second] == 0) {
          maze[pos.first - 1][pos.second] = -1;
          fire.push(make_pair(pos.first - 1, pos.second));
        }
      }
      if (pos.first < n - 1) {
        if (maze[pos.first + 1][pos.second] == 0) {
          maze[pos.first + 1][pos.second] = -1;
          fire.push(make_pair(pos.first + 1, pos.second));
        }
      }
      if (pos.second > 0) {
        if (maze[pos.first][pos.second - 1] == 0) {
          maze[pos.first][pos.second - 1] = -1;
          fire.push(make_pair(pos.first, pos.second - 1));
        }
      }
      if (pos.second < m - 1) {
        if (maze[pos.first][pos.second + 1] == 0) {
          maze[pos.first][pos.second + 1] = -1;
          fire.push(make_pair(pos.first, pos.second + 1));
        }
      }
      fire.pop();
    }

    curr_len = stevan.size();
    //   cout << curr_len << endl;
    for (int i = 0; i < curr_len; i++) {
      auto pos = stevan.front();
      if (pos.first > 0) {
        if (maze[pos.first - 1][pos.second] == 0) {
          maze[pos.first - 1][pos.second] = 5;
          stevan.push(make_pair(pos.first - 1, pos.second));
        }
      }
      if (pos.first < n - 1) {
        if (maze[pos.first + 1][pos.second] == 0) {
          maze[pos.first + 1][pos.second] = 5;
          stevan.push(make_pair(pos.first + 1, pos.second));
        }
      }
      if (pos.second > 0) {
        if (maze[pos.first][pos.second - 1] == 0) {
          maze[pos.first][pos.second - 1] = 5;
          stevan.push(make_pair(pos.first, pos.second - 1));
        }
      }
      if (pos.second < m - 1) {
        if (maze[pos.first][pos.second + 1] == 0) {
          maze[pos.first][pos.second + 1] = 5;
          stevan.push(make_pair(pos.first, pos.second + 1));
        }
      }
      stevan.pop();
    }
  }

  int snake_oil = 0;
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < m; j++) {
      if (maze[i][j] == 5) {
        snake_oil++;
      }
    }
  }

  cout << snake_oil << endl;

  return 0;
}