using System;
using System.Collections.Generic;

class Program
{
    // Klasa za predstavljanje kupovine
    class Purchase
    {
        public int Day { get; set; }
        public int Count { get; set; }
    }

    static void Main()
    {
        // Citanje broja kupovina (N) i broja upita (Q)
        string[] firstLine = Console.ReadLine().Split();
        int N = int.Parse(firstLine[0]);
        int Q = int.Parse(firstLine[1]);

        // Citanje kupovina
        var purchases = new List<Purchase>();
        for (int i = 0; i < N; i++)
        {
            string[] line = Console.ReadLine().Split();
            int day = int.Parse(line[0]);
            int count = int.Parse(line[1]);
            purchases.Add(new Purchase { Day = day, Count = count });
        }

        // Citanje upita
        int[] queries = new int[Q];
        for (int i = 0; i < Q; i++)
        {
            queries[i] = int.Parse(Console.ReadLine());
        }

        // Racunanje kumulativne kolicine keksa
        int totalBiscuits = 0;
        var biscuitsPerDay = new Dictionary<int, int>();
        foreach (var purchase in purchases)
        {
            if (!biscuitsPerDay.ContainsKey(purchase.Day))
                biscuitsPerDay[purchase.Day] = 0;

            biscuitsPerDay[purchase.Day] += purchase.Count;
            totalBiscuits += purchase.Count;
        }

        // Odgovaranje na upite
        var results = new List<int>();
        int eatenSoFar = 0;

        for (int i = 0, currentDay = 1; i < Q; i++)
        {
            int queryDay = queries[i];

            // Obrada dana do trenutnog upita
            while (currentDay <= queryDay)
            {
                if (biscuitsPerDay.ContainsKey(currentDay))
                {
                    eatenSoFar += biscuitsPerDay[currentDay];
                }

                if (eatenSoFar > 0)
                {
                    eatenSoFar--;
                    totalBiscuits--;
                }

                currentDay++;
            }

            // Cuvanje odgovora
            results.Add(totalBiscuits);
        }

        // Ispis rezultata
        foreach (var result in results)
        {
            Console.WriteLine(result);
        }
    }
}