using System;

class Program
{
    // Klasa za predstavljanje kupovine
    class Purchase
    {
        public long Day { get; set; }
        public long Count { get; set; }
    }

    static void Main()
    {

        // Citanje broja kupovina (N) i broja upita (Q)
        string[] firstLine = Console.ReadLine().Split();
        long N = long.Parse(firstLine[0]);
        long Q = long.Parse(firstLine[1]);

        // Citanje kupovina
        var purchases = new Purchase[N];
        for (long i = 0; i < N; i++)
        {
            string[] line = Console.ReadLine().Split();
            long day = long.Parse(line[0]);
            long count = long.Parse(line[1]);
            purchases[i] = new Purchase { Day = day, Count = count };
        }

        // Citanje upita
        long[] queries = new long[Q];
        for (long i = 0; i < Q; i++)
        {
            queries[i] = long.Parse(Console.ReadLine());
        }

        // Racunanje kumulativne kolicine keksa
        long totalBiscuits = 0;
        long maxDay = purchases[N - 1].Day;
        long[] biscuitsPerDay = new long[maxDay + 1];

        // Popunjavanje broja keksa po danima
        for (long i = 0; i < N; i++)
        {
            biscuitsPerDay[purchases[i].Day] += purchases[i].Count;
            totalBiscuits += purchases[i].Count;
        }

        // Odgovaranje na upite
        long[] results = new long[Q];

        for (long i = 0; i < Q; i++)
        {
            long queryDay = queries[i];

            long ukupnoKeksa = 0;
            long potrosi = 0; 

            long doDana = queryDay >= maxDay ? maxDay : queryDay;

            for(long k = 1; k<=doDana; k++)
            {
                ukupnoKeksa += biscuitsPerDay[k];

                if (ukupnoKeksa > 0)
                {
                    potrosi += 1;
                    ukupnoKeksa -= 1;
                }
            }

            potrosi += queryDay > maxDay ? (  
                ukupnoKeksa>(queryDay - maxDay) ?  (queryDay - maxDay) : ukupnoKeksa 
                ) : 0;

            results[i] = potrosi;
        }        // Ispis rezultata
        for (long i = 0; i < Q; i++)
        {
            Console.WriteLine(results[i]);
        }

        Console.ReadKey();
    }
}