using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;

namespace treci
{
    internal class Program
    {
        static void Main(string[] args)
        {
            string[] info = Console.ReadLine().Split(' ');
            int n = int.Parse(info[0]);
            int m = int.Parse(info[1]);
            bool[,] popunjeno = new bool[n, m];
            (int, int) steva = (0, 0);
            Queue<(int, int, bool)> red = new Queue<(int, int, bool)>();
            int brStevinihPolja = 0;
            for (int i = 0; i < n; i++)
            {
                string s = Console.ReadLine();
                for (int j = 0; j < m; j++)
                {
                    if (s[j] == '.')
                    {
                        popunjeno[i, j] = false;
                    }
                    else if (s[j] == '*')
                    {
                        popunjeno[i, j] = true;
                    }
                    else if (s[j] == 'X')
                    {
                        red.Enqueue((i, j, false));
                        popunjeno[i, j] = true;
                    }
                    else
                    {
                        steva = (i, j);
                        popunjeno[i, j] = true;
                    }
                }
            }
            red.Enqueue((steva.Item1, steva.Item2, true));
            while (red.Count > 0)
            {
                var polje = red.Dequeue();
                if (polje.Item3) brStevinihPolja++;
                if (polje.Item1 < n - 1 && popunjeno[polje.Item1 + 1, polje.Item2] == false)
                {
                    popunjeno[polje.Item1 + 1, polje.Item2] = true;
                    red.Enqueue((polje.Item1 + 1, polje.Item2, polje.Item3));
                }
                if (polje.Item2 < m - 1 && popunjeno[polje.Item1, polje.Item2 + 1] == false)
                {
                    popunjeno[polje.Item1, polje.Item2 + 1] = true;
                    red.Enqueue((polje.Item1, polje.Item2 + 1, polje.Item3));
                }
                if (polje.Item1 > 0 && popunjeno[polje.Item1 - 1, polje.Item2] == false)
                {
                    popunjeno[polje.Item1 - 1, polje.Item2] = true;
                    red.Enqueue((polje.Item1 - 1, polje.Item2, polje.Item3));
                }
                if (polje.Item2 > 0 && popunjeno[polje.Item1, polje.Item2 - 1] == false) 
                {
                    popunjeno[polje.Item1, polje.Item2 - 1] = true;
                    red.Enqueue((polje.Item1, polje.Item2 - 1, polje.Item3));
                }
            }
            Console.WriteLine(brStevinihPolja);
        }
    }
}