#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    long long N, Q;
    cin >> N >> Q;

    vector<long long> d(N), p(N);
    for (long long i = 0; i < N; ++i) cin >> d[i] >> p[i];

    vector<long long> queries(Q);
    for (long long i = 0; i < Q; ++i) cin >> queries[i];

    vector<long long> prefix_sum(N);
    prefix_sum[0] = p[0];
    for  (long long i = 0; i < N; ++i) prefix_sum[i] = prefix_sum[i + 1] + p[i];

    for (long long q = 0; q < Q; ++q) {
        long long k = queries[q];
        long long low = 0, high = N - 1, idx = -1;
        while (low <= high) {
            long long mid = low + (high - low) / 2;
            if (d[mid] <= k) { idx = mid; low = mid + 1; }
            else high = mid - 1;
        }
        cout << (idx == -1 ? 0 : prefix_sum[idx]) / 2 << endl;
    }

    return 0;
}