#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

vector<long long> computeProductConsumption(const vector<long long>& distances, vector<long long>& product) {
    int n = distances.size();
    vector<long long> totalConsumed(n, 0);
    for (int i = 0; i < n - 1; i++) {
        long long gap = distances[i + 1] - distances[i];
        if (product[i] <= gap) {
            totalConsumed[i + 1] = totalConsumed[i] + product[i];
        } else {
            totalConsumed[i + 1] = totalConsumed[i] + gap;
            product[i + 1] += product[i] - gap;
        }
    }
    return totalConsumed;
}

int main() {
    int n, q;
    cin >> n >> q;

    vector<long long> distances(n), product(n);
    for (int i = 0; i < n; i++) {
        cin >> distances[i] >> product[i];
    }

    vector<long long> totalConsumed = computeProductConsumption(distances, product);

    for (int i = 0; i < q; i++) {
        long long point, consumed = 0;
        cin >> point;

        int index = upper_bound(distances.begin(), distances.end(), point) - distances.begin();
        index--;

        if (index < 0) {
            cout << "0\n";
            continue;
        }

        consumed = totalConsumed[index];
        consumed += min(product[index], point + 1LL - distances[index]);
        cout << consumed << "\n";
    }

    return 0;
}