using System;
using System.Linq;

class Program
{
    static void Main()
    {
        var input = Console.ReadLine().Split(' ');
        int n = int.Parse(input[0]);
        int q = int.Parse(input[1]);

        var d = new long[n];
        var p = new long[n];

        for (int i = 0; i < n; i++)
        {
            var dp = Console.ReadLine().Split(' ').Select(long.Parse).ToArray();
            d[i] = dp[0];
            p[i] = dp[1];
        }

        var products = new long[n];
        for (int i = 0; i < n - 1; i++)
        {
            long distance = d[i + 1] - d[i];
            if (p[i] <= distance)
            {
                products[i + 1] = products[i] + p[i];
            }
            else
            {
                products[i + 1] = products[i] + distance;
                p[i + 1] += p[i] - distance;
            }
        }

        var output = new System.Text.StringBuilder();

        for (int i = 0; i < q; i++)
        {
            long broj = long.Parse(Console.ReadLine());
            long eaten = 0;

            int b = Array.BinarySearch(d, broj);
            if (b < 0) b = ~b - 1;

            if (b < 0)
            {
                output.AppendLine("0");
                continue;
            }

            eaten = products[b];

            long remaining = broj + 1 - d[b];
            if (remaining > 0)
            {
                eaten += Math.Min(p[b], remaining);
            }

            output.AppendLine(eaten.ToString());
        }

        Console.Write(output.ToString());
    }
}