#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    long long N, Q;
    cin >> N >> Q;

    vector<pair<long long, long long>> kupovine(N);  // (di, pi)
    vector<long long> upiti(Q);

    // Ucitavanje podataka o kupovinama
    for (long long i = 0; i < N; ++i) {
        cin >> kupovine[i].first >> kupovine[i].second;
    }

    // Ucitavanje upita
    for (long long i = 0; i < Q; ++i) {
        cin >> upiti[i];
    }

    // Odgovaranje na upite
    for (long long j = 0; j < Q; ++j) {
        long long k = upiti[j];  // Dan kada cerka prestaje da jede

        long long ukupnoPakovanja = 0;
        long long jelaDoDanas = 0;  // Broj pojedenih pakovanja

        // Prolazimo kroz kupovine i racunamo broj pojedenih pakovanja do dana k
        for (long long i = 0; i < N; ++i) {
            long long di = kupovine[i].first;
            long long pi = kupovine[i].second;

            // Ako je k pre nego što cerka pocne da jede Plazmu na dan di
            if (k < di) {
                break;
            }

            // Ako cerka pocinje da jede Plazmu na dan di
            if (k >= di) {
                // Cerka ce pojesti pakovanja svakog dana do dana kada bude nestalo keksa
                long long poslednjiDan = di + pi - 1;
                if (k <= poslednjiDan) {
                    // Ako je upit pre nego što je potrošila sve kekse
                    jelaDoDanas += k - di + 1;
                }
                else {
                    // Ako je potrošila sve kekse pre upita
                    jelaDoDanas += pi;
                }
            }
        }

        // Ispisujemo koliko je cerka pojela do dana k
        cout << jelaDoDanas << endl;
    }

    return 0;
}