#include <iostream>
#include <queue>
#include <vector>
#include <climits>

using namespace std;

const int DIRECTIONS[4][2] = { {-1, 0}, {1, 0}, {0, -1}, {0, 1} };  // Gorenji, donji, levi, desni pravci

int main() {
    int N, M;
    cin >> N >> M;

    vector<vector<char>> maze(N, vector<char>(M));
    pair<int, int> start;  // Pocetna pozicija Steve

    // Ucitavamo lavirint
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            cin >> maze[i][j];
            if (maze[i][j] == 'S') {
                start = { i, j };
            }
        }
    }

    // Vektori za vreme dolaska vatre i Steve
    vector<vector<int>> fireTime(N, vector<int>(M, INT_MAX));  // Vreme kada vatra stiže
    vector<vector<int>> steveTime(N, vector<int>(M, INT_MAX)); // Vreme kada Steva stiže

    // BFS za širenje požara
    queue<pair<int, int>> fireQueue;

    // Inicijalizacija FireTime sa velikim brojevima, a pocetne tacke požara sa 0
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            if (maze[i][j] == 'X') {
                fireQueue.push({ i, j });
                fireTime[i][j] = 0;
            }
        }
    }

    // BFS za širenje požara
    while (!fireQueue.empty()) {
        pair<int, int> current = fireQueue.front();
        fireQueue.pop();
        int x = current.first;
        int y = current.second;

        // Prolazimo kroz sve cetiri susedne tacke
        for (const auto& dir : DIRECTIONS) {
            int nx = x + dir[0], ny = y + dir[1];
            if (nx >= 0 && ny >= 0 && nx < N && ny < M && maze[nx][ny] == '.' && fireTime[nx][ny] == INT_MAX) {
                fireTime[nx][ny] = fireTime[x][y] + 1;
                fireQueue.push({ nx, ny });
            }
        }
    }

    // BFS za Stevu
    queue<pair<int, int>> steveQueue;

    // Inicijalizacija SteveTime sa velikim brojevima, a pocetna pozicija Steve sa 0
    steveQueue.push(start);
    steveTime[start.first][start.second] = 0;

    // BFS za Stevu
    while (!steveQueue.empty()) {
        pair<int, int> current = steveQueue.front();
        steveQueue.pop();
        int x = current.first;
        int y = current.second;

        // Prolazimo kroz sve cetiri susedne tacke
        for (const auto& dir : DIRECTIONS) {
            int nx = x + dir[0], ny = y + dir[1];
            if (nx >= 0 && ny >= 0 && nx < N && ny < M && maze[nx][ny] == '.' && steveTime[nx][ny] == INT_MAX) {
                steveTime[nx][ny] = steveTime[x][y] + 1;
                steveQueue.push({ nx, ny });
            }
        }
    }

    // Brojimo koliko slobodnih polja Steva može da stigne pre nego što vatra stigne
    int reachable = 0;
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            // Proveravamo da li je Steva stigao pre požara i da li je polje slobodno
            if (maze[i][j] == '.' && steveTime[i][j] < fireTime[i][j]) {
                reachable++;
            }
        }
    }

    cout << reachable + 1 << endl;

    return 0;
}