namespace ConsoleApp24
{
    internal class Program
    {
        static void Main(string[] args)
        {



          
            var nm = Console.ReadLine().Split();
            int N = int.Parse(nm[0]);
            int M = int.Parse(nm[1]);

           
            char[,] grid = new char[N, M];
            (int Sx, int Sy) stevePosition = (-1, -1);
            List<(int, int)> firePositions = new List<(int, int)>();

            for (int i = 0; i < N; i++)
            {
                string line = Console.ReadLine();
                for (int j = 0; j < M; j++)
                {
                    grid[i, j] = line[j];
                    if (grid[i, j] == 'S')
                    {
                        stevePosition = (i, j);
                    }
                    else if (grid[i, j] == 'X')
                    {
                        firePositions.Add((i, j));
                    }
                }
            }

           
            int[,] fireTime = new int[N, M];
            Queue<(int, int)> fireQueue = new Queue<(int, int)>();

           
            for (int i = 0; i < N; i++)
            {
                for (int j = 0; j < M; j++)
                {
                    fireTime[i, j] = -1;
                }
            }

           
            foreach (var firePos in firePositions)
            {
                fireTime[firePos.Item1, firePos.Item2] = 0;
                fireQueue.Enqueue(firePos);
            }

            
            while (fireQueue.Count > 0)
            {
                var (x, y) = fireQueue.Dequeue();
                foreach (var dir in new[] { (0, 1), (1, 0), (0, -1), (-1, 0) })
                {
                    int nx = x + dir.Item1, ny = y + dir.Item2;
                    if (nx >= 0 && nx < N && ny >= 0 && ny < M && grid[nx, ny] == '.' && fireTime[nx, ny] == -1)
                    {
                        fireTime[nx, ny] = fireTime[x, y] + 1;
                        fireQueue.Enqueue((nx, ny));
                    }
                }
            }

            
            int[,] steveTime = new int[N, M];
            Queue<(int, int)> steveQueue = new Queue<(int, int)>();

         
            for (int i = 0; i < N; i++)
            {
                for (int j = 0; j < M; j++)
                {
                    steveTime[i, j] = -1;
                }
            }

           
            var (sx, sy) = stevePosition;
            steveTime[sx, sy] = 0;
            steveQueue.Enqueue((sx, sy));

           
            while (steveQueue.Count > 0)
            {
                var (x, y) = steveQueue.Dequeue();
                foreach (var dir in new[] { (0, 1), (1, 0), (0, -1), (-1, 0) })
                {
                    int nx = x + dir.Item1, ny = y + dir.Item2;
                    if (nx >= 0 && nx < N && ny >= 0 && ny < M && grid[nx, ny] == '.' && steveTime[nx, ny] == -1)
                    {
                        steveTime[nx, ny] = steveTime[x, y] + 1;
                        steveQueue.Enqueue((nx, ny));
                    }
                }
            }

            
            int result = 0;
            for (int i = 0; i < N; i++)
            {
                for (int j = 0; j < M; j++)
                {
                   
                    if (grid[i, j] == '.' && steveTime[i, j] != -1 &&
                        (fireTime[i, j] == -1 || steveTime[i, j] < fireTime[i, j]))
                    {
                        result++;
                    }
                }
            }

            Console.WriteLine(result);


        }
    }
}