#include <bits/stdc++.h>

using namespace std;

int rast_vatre[1001][1001];
int rast_steve[1001][1001];
char matrica[1001][1001];
bool prosao[1001][1001];

int kretanjex[] = {-1, 0, 1, 0};
int kretanjey[] = {0, 1, 0, -1};

struct Polje
{
  int x;
  int y;
  int vreme;

  Polje(int x1, int y1, int t)
  {
    x = x1;
    y = y1;
    vreme = t;
  }
};

bool Provera_prekoracenja(int x, int y, int n, int m)
{
  return (x >= 0 && x < n && y >= 0 && y < m);
}

int Resenje(int n, int m)
{
  int brojac = 1;
  queue<Polje> q1;
  int stevax = -1, stevay = -1;

  for (int i = 0; i < n; i++)
  {
    for (int j = 0; j < m; j++)
    {
      rast_steve[i][j] = INT_MAX;
      rast_vatre[i][j] = INT_MAX;
      prosao[i][j] = false;

      if (matrica[i][j] == 'S')
      {
        stevax = i;
        stevay = j;
        rast_steve[i][j] = 0;
        prosao[i][j] = true;
      }
      else if (matrica[i][j] == 'X')
      {
        q1.push(Polje(i, j, 0));
        rast_vatre[i][j] = 0;
      }
    }
  }

  while(!q1.empty())
  {
    Polje trenutno = q1.front();
    q1.pop();

    for (int i = 0; i < 4; i++)
    {
      int x1 = trenutno.x + kretanjex[i];
      int y1 = trenutno.y + kretanjey[i];

      if (Provera_prekoracenja(x1, y1, n, m) && matrica[x1][y1] != '*' && rast_vatre[x1][y1] == INT_MAX)
      {
        rast_vatre[x1][y1] = trenutno.vreme + 1;
        q1.push(Polje(x1, y1, trenutno.vreme + 1));
      }
    }
  }


  queue<Polje> q2;
  q2.push(Polje(stevax, stevay, 0));

  while(!q2.empty())
  {
    Polje trenutno = q2.front();
    q2.pop();

    for (int i = 0; i < 4; i++)
    {
      int x1 = trenutno.x + kretanjex[i];
      int y1 = trenutno.y + kretanjey[i];

      if (Provera_prekoracenja(x1, y1, n, m) && matrica[x1][y1] != '*' && prosao[x1][y1] == false && trenutno.vreme + 1 < rast_vatre[x1][y1])
      {
          brojac++;
          prosao[x1][y1] = true;
          rast_steve[x1][y1] = trenutno.vreme + 1;
          q2.push(Polje(x1, y1, trenutno.vreme + 1));
      }
    }
  }

  return brojac;
}


int main()
{
  ios_base::sync_with_stdio(false);
  cin.tie();

  int n, m;
  cin >> n >> m;
  string red;

  for (int i = 0; i < n; i++)
  {
    cin >> red;
    for (int j = 0; j < m; j++)
    {
      matrica[i][j] = red[j];
    }
  }

  cout << Resenje(n, m) << endl;

  return 0;
}