#include <bits/stdc++.h>
using namespace std;

// Binary search helper
int findLargestSmallerIndex(const vector<long long>& arr, long long x) {
    int left = 0, right = arr.size() - 1;
    int result = -1;
    
    while (left <= right) {
        int mid = left + (right - left) / 2;
        if (arr[mid] < x) {
            result = mid;
            left = mid + 1;
        } else {
            right = mid - 1;
        }
    }
    return result;
}

struct Purchase {
    long long day;
    long long cumSum;
    long long packets;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int N, Q;
    cin >> N >> Q;
    
    // Read first purchase separately
    long long firstDay, firstPackets;
    cin >> firstDay >> firstPackets;
    
    vector<Purchase> purchases;
    vector<long long> days;
    long long cumSum = firstPackets;
    
    // Process remaining purchases
    for (int i = 1; i < N; i++) {
        long long day, packets;
        cin >> day >> packets;
        days.push_back(day - 1);
        purchases.push_back({day - 1, cumSum, packets});
        cumSum += packets;
    }
    
    // Process queries
    for (int i = 0; i < Q; i++) {
        long long q;
        cin >> q;
        
        if (q < firstDay) {
            cout << "0\n";
            continue;
        }
        
        int index = findLargestSmallerIndex(days, q);
        if (index == -1) {
            cout << min(firstPackets, q - firstDay + 1) << '\n';
        } else {
            cout << purchases[index].cumSum + 
                    min(q - purchases[index].day, purchases[index].packets) << '\n';
        }
    }
    
    return 0;
}