#include <cstdint>
#include <cstdio>
#include <iostream>
#include <memory>
#include <ostream>
#include <vector>
#include <sstream>

using namespace std;

std::vector<uint32_t>int_arr_input(const uint16_t len) {
  string input;
  getline(cin, input, '\n');
  auto out = vector<uint32_t>(len);
  istringstream iss(input);
  for (int i = 0; i < len; i++) {
    iss >> out[i];
  }
  return out;
}

int main() {
  uint16_t nfts_count, bros_count;
  cin >> nfts_count >> bros_count;
  std::cin.ignore();
  auto nfts = int_arr_input(nfts_count);
  auto bros_sums = make_unique<int[]>(bros_count);

  uint16_t bro_i = 0;

  uint16_t nfts_taken = 0;
  uint16_t nfts_left = nfts_count;
  // To slice off already taken nfts
  uint16_t cursor_t = 0;
  uint16_t cursor_b = nfts_count - 1;

  // For every brother except the last one
  uint16_t must_take_top = 0;
  uint16_t must_take_bottom = 0;

  while (nfts_taken < nfts_count) {
    // recalculate the smallest pair possible for last bro 
    if (bro_i == 0) {
      if (nfts_left >= bros_count) {
        // if there are more nfts left than brothers we try to get the smallest sum
        // for the last brother
        must_take_bottom = bros_count - 1;
        must_take_top = 0;
        uint16_t min_sum_val = nfts[cursor_t] + nfts[cursor_b-must_take_bottom];
        for (uint16_t cursor = 1; cursor < bros_count - 1; cursor++) {
          auto bottom = nfts[cursor_b-bros_count+cursor+1];
          auto top = nfts[cursor_t+cursor];
          uint64_t new_sum = bottom+top;
          if (min_sum_val > new_sum) {
            min_sum_val = new_sum;
            must_take_bottom = bros_count - (cursor + 1);
            must_take_top = cursor;
          }
        }
      } else {
        // just take everything
        must_take_top = nfts_left;
        must_take_bottom = nfts_left;
      }
    }
    // take the biggest from top/bottom
    if ((bro_i == bros_count - 1 || must_take_top) && (nfts[cursor_t] >= nfts[cursor_b] || (!must_take_bottom && must_take_top))) {
      bros_sums[bro_i] += nfts[cursor_t];
      if (bro_i != bros_count - 1) { must_take_top--; }
      cursor_t++;
    } else if (bro_i == bros_count - 1 || must_take_bottom) {
      bros_sums[bro_i] += nfts[cursor_b];
      if (bro_i != bros_count - 1) { must_take_bottom--; }
      cursor_b--;
    }
    bro_i = (bro_i + 1) % bros_count;
    nfts_taken++;
    nfts_left--;
  }

  for (int16_t i = 0; i < bros_count; i++) {
    cout << bros_sums[i] << ' '; 
  }
  cout << '\n';
  return 0;
}