#include <iostream>
#include <cstring>

using namespace std;

int nfts[100];
int best_score[100][100][100];

int solve(int left, int right, int turn, int number_of_brothers, int number_of_nfts) {
    if(left > right) {
        return 0;
    }

    if(best_score[left][right][turn] != -1) {
        return best_score[left][right][turn];
    } 

    int result;
    if(turn == 0) {
        result = -1000000000;
        result = max(result, nfts[left] + solve(left + 1, right, (turn + 1) % number_of_brothers, number_of_brothers, number_of_nfts));
        result = max(result, nfts[right] + solve(left, right - 1, (turn + 1) % number_of_brothers, number_of_brothers, number_of_nfts));
    } else {  
        result = 1000000000;
        result = min(result, solve(left + 1, right, (turn + 1) % number_of_brothers, number_of_brothers, number_of_nfts));
        result = min(result, solve(left, right - 1, (turn + 1) % number_of_brothers, number_of_brothers, number_of_nfts));
    }

    return best_score[left][right][turn] = result;
}

int main() {
    int number_of_nfts, number_of_brothers;
    cin >> number_of_nfts >> number_of_brothers;

    for(int i = 0; i < number_of_nfts; i++) {
        cin >> nfts[i];
    }

    int results[number_of_brothers];
    for(int i = 0; i < number_of_brothers; i++) {
        memset(best_score, -1, sizeof(best_score));
        results[i] = solve(0, number_of_nfts - 1, i, number_of_brothers, number_of_nfts);
    }

    swap(results[1], results[number_of_brothers - 1]);

    for(int i = 0; i < number_of_brothers; i++) {
        cout << results[i] << " ";
    }

    cout << endl;
    return 0;
}