#include <bits/stdc++.h>

using namespace std;

const int max_n = 2e5 + 5;

vector<int> children[max_n];
set<int> adjs[max_n];
int branch[max_n][2];
vector<int> ans;


void dfs(int mid){
    int c1 = -1, c2 = -1;
    if (children[mid].size() > 0){ // da li ima prvo dete
        if (adjs[children[mid][0]].count(branch[mid][0])) c1 = children[mid][0];
        if (adjs[children[mid][0]].count(branch[mid][1])) c2 = children[mid][0];
    }
    if (children[mid].size() > 1){
        if (adjs[children[mid][1]].count(branch[mid][0]) && (c1 == c2 || c1 == -1))
            c1 = children[mid][1];
        if (adjs[children[mid][1]].count(branch[mid][1]) && (c1 == c2 || c2 == -1))
            c2 = children[mid][1];
    }
    if (c1 != -1){
        branch[c1][0] = branch[mid][0];
        branch[c1][1] = mid;
        dfs(c1);
    }
    ans.push_back(mid);
    if (c2 != -1 && c2 != c1){
        branch[c2][0] = mid;
        branch[c2][1] = branch[mid][1];
        dfs(c2);
    }
}


int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n, a, b, c, p;
    cin >> n;
    vector<int> lvl(n + 1, 0);
    lvl[4] = 1;
    for (int mid = 5; mid <= n; mid++){
        cin >> a >> b >> c;
        adjs[mid].insert(a);
        adjs[mid].insert(b);
        adjs[mid].insert(c);
        lvl[mid] = max(max(lvl[a], lvl[b]), lvl[c]) + 1;
        if (lvl[a] + 1 == lvl[mid]) p = a;
        else if (lvl[b] + 1 == lvl[mid]) p = b;
        else p = c;
        children[p].push_back(mid);
    }
    branch[4][0] = 3;
    branch[4][1] = 1;
    ans.push_back(1);
    ans.push_back(2);
    ans.push_back(3);
    dfs(4);
    ans.push_back(1);
    for (int elm : ans) cout << elm << " ";
    cout << endl;
    return 0;
}