#include <iostream>
#include <algorithm>
#include <vector>

using namespace std;

void getCombinations(int l, int r, int needed, vector<pair<int,int>>& combinations, int amount = 0){
  if (l > r) return;

  if (amount == needed){
    combinations.push_back({l,r});
    return;
  }

  ++amount;
  getCombinations(l+1,r,needed,combinations,amount);
  getCombinations(l,r-1,needed,combinations,amount);
}

int recursive(int l, int r, int M, vector<vector<int>>& memoization, vector<int>& amount){
  if (l > r) return 0;
  if (memoization[l][r] != -1) return memoization[l][r];

  vector<pair<int,int>> leftPairs,rightPairs;

  getCombinations(l+1,r,M,leftPairs,1);
  getCombinations(l,r-1,M,rightPairs,1);

  int left = amount[l], right = amount[r];
  int leftMin = -1, rightMin = -1;

  for (auto pair: leftPairs){
    int num = recursive(pair.first,pair.second,M,memoization,amount);
    if (leftMin == -1 || num < leftMin) leftMin = num;
  }

  for (auto pair: rightPairs){
    int num = recursive(pair.first,pair.second,M,memoization,amount);
    if (rightMin == -1 || num < rightMin) rightMin = num;
  }

  if (leftMin != -1) left+=leftMin;
  if (rightMin != -1) right+=rightMin;

  int num = max(left,right);
  memoization[l][r] = num;
  
  return num;
}

int solve(int i, int N, int M, vector<vector<int>>& memoization, vector<int>& amount){
  vector<pair<int,int>> combinations;

  getCombinations(0,N-1,i,combinations);

  int ans = -1;

  for (auto pair: combinations){
    int num = recursive(pair.first,pair.second,M,memoization,amount);
    if (ans == -1 || num < ans)ans = num;
  }

  return ans;
}

int main(){
  ios_base::sync_with_stdio(false),cin.tie(0);

  int N,M; cin>>N>>M;

  vector<vector<int>> memoization(N,vector<int>(N,-1));
  vector<int> amount(N);

  for (int i = 0; i < N; ++i){
    cin>>amount[i];
  }

  for (int i = 0; i < M; ++i){
    cout<<solve(i,N,M,memoization,amount)<<' ';
  }

  return 0;
}