#include <iostream>
#include <algorithm>
#include <vector>
#include <queue>

using namespace std;

int main(){
  ios_base::sync_with_stdio(false),cin.tie(0);

  int n; cin>>n;
  vector<int> depths(n,0);
  vector<vector<int>> pairs(n,vector<int>());

  for (int i = 0; i < 3; ++i){
    for (int j = 0; j < 3; ++j){
      if (i == j) continue;
      pairs[j].push_back(i);
    }
  }

  for (int i = 3; i < n; ++i){
    int a = 1,b = 2,c = 3;
    
    if (i >= 4){
      cin>>a>>b>>c;
    }

    pairs[--a].push_back(i);
    pairs[--b].push_back(i);
    pairs[--c].push_back(i);

    int depth = max(depths[a],max(depths[b],depths[c]))+1;
    depths[i] = depth;

    pairs[i].insert(pairs[i].end(),{a,b,c});
  }

  vector<bool> visited(n,false);
  vector<int> path(n+1);

  int visitingIndex = 0, totalVisited = 0;
  bool success = false;

  while (true){
    visited[visitingIndex] = true;
    path[totalVisited++] = visitingIndex+1;

    if (totalVisited > n) {
      success = true;
      break;
    }

    auto others = pairs[visitingIndex];

    int chosen = -1;

    for (int num: others){
      if (totalVisited == n){
        if (num == 0){
          chosen = 0;
          break;
        }
      }else{
        if (visited[num] || (chosen != -1 && depths[chosen] >= depths[num])) continue;
        chosen = num;
      }
    }

    if (chosen == -1) break;
    visitingIndex = chosen;
  }

  if (success){
    for (int num: path){
      cout<<num<<' ';
    }
  }else{
    cout<<-1;
  }

  return 0;
}