#include <iostream>
#include <vector>

using namespace std;

#define beskonacno 1000000000

void daltonizacija(vector<vector<int> > &memo, vector<int> &a, int m, int x, int y) {
	if(x > y) {
		memo[x][y] = 0;
		return;
	}
	if(x == y) {
		memo[x][y] = a[x];
		return;
	}
	if(memo[x][y] != beskonacno)
		return;
	
	int maximin1 = beskonacno;
	int x1 = x + 1, y1 = y - m + 1;
	while(y1 <= y) {
		if(x1 < 0 || y1 < 0)
			break;
		daltonizacija(memo, a, m, x1, y1);
		maximin1 = min(maximin1, memo[x1][y1]);
		x1++;
		y1++;
	}
	
	int maximin2 = beskonacno;
	x1 = x, y1 = y - m;
	while(y1 < y) {
		if(x1 < 0 || y1 < 0)
			break;
		daltonizacija(memo, a, m, x1, y1);
		maximin2 = min(maximin2, memo[x1][y1]);
		x1++;
		y1++;
	}
	
	memo[x][y] = max(a[x] + maximin1, a[y] + maximin2);
}

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(NULL);

	int n, m;
	cin >> n >> m;
	vector<int> a(n);
	for(int i = 0; i < n; i++)
		cin >> a[i];
	
	vector<vector<int> > memo(2*n, vector<int>(2*n, beskonacno));
	for(int i = 0; i < m; i++) {
		int nft = beskonacno;
		int x1 = 0, y1 = n - 1 - i;
		while(y1 < n) {
			daltonizacija(memo, a, m, x1, y1);
			
			nft = min(nft, memo[x1][y1]);
			
			x1++;
			y1++;
		}
		
		cout << nft << ' ';
	}
	
	return 0;
}