#include <iostream>
#include <vector>
#include <unordered_map>

using namespace std;

struct HashSet {
	unordered_map<long long, int> mapa;
	int ogranicenje;
	
	void Ogranicenje(int n) {
		ogranicenje = n + 1;
	}
	
	void Ubaci(int a, int b, int c, int x) {
		int a1 = min(min(a, b), c);
		int c1 = max(max(a, b), c);
		int b1 = a + b + c - a1 - c1;
		long long kljuc = 1ll * ogranicenje * ogranicenje * a1 + 1ll * ogranicenje * b1 + 1ll * c1;
		mapa[kljuc] = x;
	}
	
	int Trazi(int a, int b, int c) {
		int a1 = min(min(a, b), c);
		int c1 = max(max(a, b), c);
		int b1 = a + b + c - a1 - c1;
		long long kljuc = 1ll * ogranicenje * ogranicenje * a1 + 1ll * ogranicenje * b1 + 1ll * c1;
		if(mapa.count(kljuc))
			return mapa.at(kljuc);
		return 0;
	}
};

int put(HashSet &prodavnica, vector<int> &ispis, int A, int B, int C, int i) {
	if(prodavnica.Trazi(A, B, C) == 0) {
		ispis[i++] = A;
		ispis[i++] = C;
		ispis[i++] = B;
		return i;
	}
	
	int X = prodavnica.Trazi(A, B, C);
	
	if(prodavnica.Trazi(A, B, X) == 0) {
		int i1 = put(prodavnica, ispis, A, C, X, i);
		return put(prodavnica, ispis, X, B, C, i1 - 2);
	}else if(prodavnica.Trazi(A, C, X) == 0) {
		int i1 = put(prodavnica, ispis, A, B, X, i);
		return put(prodavnica, ispis, X, C, B, i1 - 2);
	}else if(prodavnica.Trazi(B, C, X) == 0) {
		int i1 = put(prodavnica, ispis, B, A, X, i);
		return put(prodavnica, ispis, X, C, A, i1 - 2);
	}
	cout << -1;
	exit(0);
}

void put(HashSet &prodavnica, vector<int> &ispis) {
	put(prodavnica, ispis, 1, 2, 3, 0);
	ispis[ispis.size() - 1] = ispis[0];
}

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(NULL);
	
	int n;
	cin >> n;
	HashSet prodavnica;
	prodavnica.Ogranicenje(n);
	prodavnica.Ubaci(1, 2, 3, 4);
	for(int i = 5; i <= n; i++) {
		int a, b, c;
		cin >> a >> b >> c;
		
		prodavnica.Ubaci(a, b, c, i);
	}
	
	vector<int> ispis(n+1);
	put(prodavnica, ispis);
	
	long long sum = 0;
	for(int i = 0; i < n; i++)
		sum += ispis[i];
	if(1ll * n * (n + 1) / 2 != sum) {
		cout << -1;
		exit(0);
	}
	
	for(int i = 0; i < ispis.size(); i++)
		cout << ispis[i] << ' ';
	cout << endl;
	
	return 0;
}