#include <iostream>
#include <vector>

using namespace std;

vector<int> res;

void dfs(int v, vector<vector<int>>& graf, vector<bool>& posecen)
{   
    posecen[v] = true;
    if (v != 0) res.push_back(v);
    else res.push_back(1);
    for (int i = graf[v].size() - 1; i >= 0; i--) {
        if (!posecen[graf[v][i]]) dfs(graf[v][i], graf, posecen);
    }

}

int main()
{
    int n;
    cin >> n;

    vector<vector<int>> graf(n + 1);

    for (int i = 0; i < 5; i++) {
        for (int j = 0; j < 5; j++) {
            if (i != j) graf[i].push_back(j);
        }
    }

    vector<bool> posecen(n , false);

    for (int i = 5; i <= n; i++) {
        int a, b, c;
        cin >> a >> b >> c;
        graf[i].push_back(a);
        graf[i].push_back(b); 
        graf[i].push_back(c);

        graf[a].push_back(i);
        graf[b].push_back(i); 
        graf[c].push_back(i);

        if(a == 1 || b == 1 || c == 1) {
            graf[0].push_back(i);
            graf[i].push_back(0);
        }
    }

    dfs(0, graf, posecen);

    if (res.size() == n + 1) {
        for (int x : res) cout << x << ' ';
            cout << endl;
    }
    else cout << -1 << endl;
    
    return 0;
}