import java.util.List;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Scanner;

public class Glavni {
    public static void main(String[] args) {
        Scanner skener = new Scanner(System.in);

        
        int n = skener.nextInt();

        
        List<Integer>[] graf = new ArrayList[n + 1];
        for (int i = 0; i <= n; i++) {
            graf[i] = new ArrayList<>();
        }

        
        graf[1].add(2); graf[2].add(1);
        graf[1].add(3); graf[3].add(1);
        graf[2].add(3); graf[3].add(2);

        
        for (int i = 4; i <= n; i++) {
            int a = skener.nextInt();
            int b = skener.nextInt();
            int c = skener.nextInt();

            graf[i].add(a); graf[a].add(i);
            graf[i].add(b); graf[b].add(i);
            graf[i].add(c); graf[c].add(i);
        }

        
        boolean[] poseceno = new boolean[n + 1];
        List<Integer> putanja = new ArrayList<>();

        
        putanja.add(1);
        poseceno[1] = true;

        
        Stack<Integer> stek = new Stack<>();
        stek.push(1);

        while (!stek.isEmpty()) {
            int trenutna = stek.pop();

           
            for (int sused : graf[trenutna]) {
                if (!poseceno[sused]) {
                    putanja.add(sused);
                    poseceno[sused] = true;
                    stek.push(sused);
                }
            }
        }

       
        putanja.add(1);

       
        for (int prodavnica : putanja) {
            System.out.print(prodavnica + " ");
        }
    }
}